/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.worldgen.features;

import architectspalette.content.worldgen.features.configs.CrystalClusterConfig;
import architectspalette.core.registry.APTags;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CrystalClusterFeature
extends Feature<CrystalClusterConfig> {
    public CrystalClusterFeature(Codec<CrystalClusterConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<CrystalClusterConfig> context) {
        if (!context.level().isEmptyBlock(context.origin())) {
            return false;
        }
        if (((CrystalClusterConfig)context.config()).hanging ? context.level().isEmptyBlock(context.origin().above()) : context.level().isEmptyBlock(context.origin().below())) {
            return false;
        }
        CrystalClusterConfig config = (CrystalClusterConfig)context.config();
        RandomSource random = context.random();
        Vector3f shelfAngle = new Vector3f(-1.0f, 0.0f, 0.0f);
        shelfAngle.rotateY(random.nextFloat() * 2.0f * (float)Math.PI);
        Vector3f formationAngle = new Vector3f((Vector3fc)shelfAngle);
        formationAngle.rotateY((float)Math.toDegrees(CrystalClusterFeature.fRandomRange(random, -15.0f, 15.0f) + 90.0f));
        Vector3f placePos = new Vector3f((float)context.origin().getX(), (float)context.origin().getY(), (float)context.origin().getZ());
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>(List.of());
        int shelves = CrystalClusterFeature.iRandomRange(random, 4, 7);
        for (int i = 0; i < shelves; ++i) {
            float scale = ((float)i + 1.0f) / (float)shelves;
            int pillars = CrystalClusterFeature.iRandomRange(random, 1, 7);
            CrystalClusterFeature.placeShelf(BlockPos.containing((double)placePos.x(), (double)placePos.y(), (double)placePos.z()), pillars, shelfAngle, scale, context, posList);
            formationAngle.normalize();
            formationAngle.mul(CrystalClusterFeature.fRandomRange(random, 0.5f, 2.0f));
            placePos.add((Vector3fc)formationAngle);
        }
        for (BlockPos pos : posList) {
            CrystalClusterFeature.tryPlaceExtrusion(pos, context.level(), config.extrusionState, config.crystalState.getBlock(), config.hanging ? 1 : -1, random);
        }
        return true;
    }

    private static void placeShelf(BlockPos startPos, int crystals, Vector3f shelfAngle, float shelfScale, FeaturePlaceContext<CrystalClusterConfig> context, List<BlockPos> crystalList) {
        RandomSource random = context.random();
        CrystalClusterConfig config = (CrystalClusterConfig)context.config();
        WorldGenLevel world = context.level();
        int flip = config.hanging ? 1 : -1;
        Vector3f placePos = new Vector3f((float)startPos.getX(), (float)startPos.getY(), (float)startPos.getZ());
        placePos.add(0.0f, (float)(-2 * flip), 0.0f);
        for (int i = 0; i < crystals; ++i) {
            Vector3f offset = new Vector3f((Vector3fc)shelfAngle);
            offset.mul(CrystalClusterFeature.fRandomRange(random, 0.5f, 2.5f));
            placePos.add((Vector3fc)offset);
            int pillarLength = config.minLength + random.nextInt((int)Math.floor((float)(config.maxLength - config.minLength) * shelfScale) + 1);
            CrystalClusterFeature.placePillar(new BlockPos.MutableBlockPos((double)placePos.x(), (double)placePos.y(), (double)placePos.z()), pillarLength, world, context, flip, crystalList);
            if (pillarLength <= (config.maxLength - config.minLength) / 2 || !random.nextBoolean()) continue;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((double)(placePos.x() + (float)CrystalClusterFeature.iRandomRange(random, -1, 1)), (double)(placePos.y() + (float)CrystalClusterFeature.iRandomRange(random, -1, 1)), (double)(placePos.z() + (float)CrystalClusterFeature.iRandomRange(random, -1, 1)));
            CrystalClusterFeature.placePillar(pos, pillarLength / 2, world, context, flip, crystalList);
        }
    }

    private static void placePillar(BlockPos.MutableBlockPos placePos, int length, WorldGenLevel world, FeaturePlaceContext<CrystalClusterConfig> context, int flip, List<BlockPos> crystalList) {
        CrystalClusterConfig config = (CrystalClusterConfig)context.config();
        int tries = 10;
        while (CrystalClusterFeature.canReplaceAt(world, (BlockPos)placePos)) {
            placePos.setY(placePos.getY() + flip);
            if (world.getBlockState((BlockPos)placePos).is(Blocks.LAVA)) {
                return;
            }
            if (tries-- != 0) continue;
            return;
        }
        tries = 5;
        while (!CrystalClusterFeature.canReplaceAt(world, (BlockPos)placePos)) {
            placePos.setY(placePos.getY() - flip);
            if (tries-- != 0) continue;
            return;
        }
        boolean doExtrusion = true;
        while (--length >= 0) {
            if (!CrystalClusterFeature.canReplaceAt(world, (BlockPos)placePos)) {
                return;
            }
            if (doExtrusion) {
                crystalList.add(placePos.immutable());
                doExtrusion = false;
            }
            world.setBlock((BlockPos)placePos, config.crystalState, 2);
            placePos.setY(placePos.getY() - flip);
        }
    }

    private static void tryPlaceExtrusion(BlockPos startPos, WorldGenLevel level, BlockState placeState, Block avoidBlock, int flip, RandomSource random) {
        for (Direction dir : Direction.values()) {
            if (dir.getAxis() == Direction.Axis.Y || random.nextInt(3) != 1) continue;
            BlockPos pos = startPos.relative(dir, 1);
            while (level.getBlockState(pos).is(placeState.getBlock()) && Math.abs(startPos.getY() - pos.getY()) <= 4) {
                pos = pos.below(flip);
            }
            BlockPos above = pos.above();
            BlockPos below = pos.below();
            if (!(CrystalClusterFeature.canReplaceAt(level, above) ^ CrystalClusterFeature.canReplaceAt(level, below)) || level.getBlockState(above).is(avoidBlock) || level.getBlockState(below).is(avoidBlock)) continue;
            for (int i = CrystalClusterFeature.iRandomRange(random, 1, 2); i > 0 && CrystalClusterFeature.canReplaceAt(level, pos); --i) {
                level.setBlock(pos, placeState, 2);
                pos = pos.below(flip);
            }
        }
    }

    private static int iRandomRange(RandomSource random, int min, int max) {
        return min + random.nextInt(max - min + 1);
    }

    private static float fRandomRange(RandomSource random, float min, float max) {
        return min + random.nextFloat() * (max - min);
    }

    private static boolean canReplaceAt(WorldGenLevel level, BlockPos pos) {
        return CrystalClusterFeature.canReplace(level.getBlockState(pos));
    }

    private static boolean canReplace(BlockState state) {
        return state.isAir() || state.canBeReplaced() || state.is(APTags.CRYSTAL_REPLACEABLE);
    }
}

