/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WizardParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final Quaternionf rotation;
    private static final Vec3 DEFAULT_PARTICLE_DIRECTION = new Vec3(0.0, 0.0, -1.0);

    protected WizardParticle(ClientLevel level, double xPos, double yPos, double zPos, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprite) {
        super(level, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.sprites = sprite;
        this.setSpriteFromAge(sprite);
        this.lifetime = 6;
        this.scale(2.0f);
        Vec3 facing = new Vec3(xSpeed, ySpeed, zSpeed).normalize();
        Vec3 def = DEFAULT_PARTICLE_DIRECTION;
        Vec3 cross = def.cross(facing).normalize();
        double rotationAngle = Math.acos(def.dot(facing));
        Vector3f rotationAxis = cross.length() == 0.0 ? new Vector3f(1.0f, 0.0f, 0.0f) : new Vector3f((float)cross.x, (float)cross.y, (float)cross.z);
        this.rotation = new Quaternionf(new AxisAngle4f((float)rotationAngle, (Vector3fc)rotationAxis));
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        Quaternionf quat;
        Vec3 pos = camera.getPosition();
        Vector3f center = new Vector3f((float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - pos.x), (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - pos.y), (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - pos.z));
        if (this.roll == 0.0f) {
            quat = this.rotation;
        } else {
            quat = new Quaternionf((Quaternionfc)this.rotation);
            quat.rotateZ(Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll));
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float size = this.getQuadSize(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quat);
            vector3f.mul(size);
            vector3f.add((Vector3fc)center);
        }
        float f7 = this.getU0();
        float f8 = this.getU1();
        float f5 = this.getV0();
        float f6 = this.getV1();
        int j = this.getLightColor(partialTicks);
        vertexConsumer.addVertex(avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).setUv(f8, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        vertexConsumer.addVertex(avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).setUv(f8, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        vertexConsumer.addVertex(avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).setUv(f7, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        vertexConsumer.addVertex(avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).setUv(f7, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet p_106827_) {
            this.sprite = p_106827_;
        }

        public Particle createParticle(SimpleParticleType p_106838_, ClientLevel p_106839_, double p_106840_, double p_106841_, double p_106842_, double p_106843_, double p_106844_, double p_106845_) {
            return new WizardParticle(p_106839_, p_106840_, p_106841_, p_106842_, p_106843_, p_106844_, p_106845_, this.sprite);
        }
    }
}

