/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.util;

import architectspalette.core.registry.APBlocks;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public interface APWeatheringCopper
extends ChangeOverTimeBlock<WeatheringCopper.WeatherState> {
    public static final Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)APBlocks.COPPER_NUB.get(), (Object)APBlocks.EXPOSED_COPPER_NUB.get());
        builder.put((Object)APBlocks.EXPOSED_COPPER_NUB.get(), (Object)APBlocks.WEATHERED_COPPER_NUB.get());
        builder.put((Object)APBlocks.WEATHERED_COPPER_NUB.get(), (Object)APBlocks.OXIDIZED_COPPER_NUB.get());
        return builder.build();
    });
    public static final Supplier<BiMap<Block, Block>> PREVIOUS_BY_BLOCK = Suppliers.memoize(() -> NEXT_BY_BLOCK.get().inverse());
    public static final Supplier<BiMap<Block, Block>> WAXED_BY_BLOCK = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)APBlocks.COPPER_NUB.get(), (Object)APBlocks.WAXED_COPPER_NUB.get());
        builder.put((Object)APBlocks.EXPOSED_COPPER_NUB.get(), (Object)APBlocks.WAXED_EXPOSED_COPPER_NUB.get());
        builder.put((Object)APBlocks.WEATHERED_COPPER_NUB.get(), (Object)APBlocks.WAXED_WEATHERED_COPPER_NUB.get());
        builder.put((Object)APBlocks.OXIDIZED_COPPER_NUB.get(), (Object)APBlocks.WAXED_OXIDIZED_COPPER_NUB.get());
        return builder.build();
    });
    public static final Supplier<BiMap<Block, Block>> UNWAXED_BY_BLOCK = Suppliers.memoize(() -> WAXED_BY_BLOCK.get().inverse());

    public static Optional<Block> getPrevious(Block block) {
        return Optional.ofNullable((Block)PREVIOUS_BY_BLOCK.get().get((Object)block));
    }

    public static Optional<BlockState> getPrevious(BlockState stateIn) {
        return APWeatheringCopper.getPrevious(stateIn.getBlock()).map(block -> block.withPropertiesOf(stateIn));
    }

    public static Optional<Block> getNext(Block block) {
        return Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)block));
    }

    default public Optional<BlockState> getNext(BlockState state) {
        return APWeatheringCopper.getNext(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    public static Optional<Block> getWaxed(Block block) {
        return Optional.ofNullable((Block)WAXED_BY_BLOCK.get().get((Object)block));
    }

    public static Optional<BlockState> getWaxed(BlockState state) {
        return APWeatheringCopper.getWaxed(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    public static Optional<Block> getUnWaxed(Block block) {
        return Optional.ofNullable((Block)UNWAXED_BY_BLOCK.get().get((Object)block));
    }

    public static Optional<BlockState> getUnWaxed(BlockState state) {
        return APWeatheringCopper.getUnWaxed(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    public static Block getFirst(Block baseBlock) {
        Block block = baseBlock;
        Block block1 = (Block)PREVIOUS_BY_BLOCK.get().get((Object)block);
        while (block1 != null) {
            block = block1;
            block1 = (Block)PREVIOUS_BY_BLOCK.get().get((Object)block1);
        }
        return block;
    }

    default public float getChanceModifier() {
        return this.getAge() == WeatheringCopper.WeatherState.UNAFFECTED ? 0.75f : 1.0f;
    }

    public static ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Optional<BlockState> waxed;
        if (stack.getItem() instanceof HoneycombItem && (waxed = APWeatheringCopper.getWaxed(state)).isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            world.setBlock(pos, waxed.get(), 11);
            world.levelEvent(player, 3003, pos, 0);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

