/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.entrails;

import architectspalette.content.blocks.entrails.DrippySlabBlock;
import architectspalette.content.blocks.entrails.DrippyVerticalSlabBlock;
import architectspalette.core.registry.util.IBlockSetBase;
import architectspalette.core.registry.util.StoneBlockSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DrippyBlock
extends Block
implements IBlockSetBase {
    public DrippyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public Block getBlockForPart(StoneBlockSet.SetComponent part, BlockBehaviour.Properties properties, Block base) {
        return switch (part) {
            case StoneBlockSet.SetComponent.SLAB -> new DrippySlabBlock(properties);
            case StoneBlockSet.SetComponent.VERTICAL_SLAB -> new DrippyVerticalSlabBlock(properties);
            default -> IBlockSetBase.super.getBlockForPart(part, properties, base);
        };
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        DrippyBlock.doParticleEffect(stateIn, worldIn, pos, rand);
    }

    public static void doParticleEffect(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        Direction direction;
        if (rand.nextInt(6) == 0 && (direction = Direction.getRandom((RandomSource)rand)) != Direction.UP && direction != Direction.DOWN) {
            BlockPos posBelow = pos.relative(Direction.DOWN);
            BlockState stateBelow = worldIn.getBlockState(posBelow);
            if (!stateIn.canOcclude() || !stateBelow.isFaceSturdy((BlockGetter)worldIn, posBelow, Direction.UP)) {
                double xOffset = direction.getStepX() == 0 ? rand.nextDouble() : 0.5 + (double)direction.getStepX() * 0.45;
                double zOffset = direction.getStepZ() == 0 ? rand.nextDouble() : 0.5 + (double)direction.getStepZ() * 0.45;
                Vec3 dropPos = new Vec3((double)pos.getX() + xOffset, (double)pos.getY() - 0.1, (double)pos.getZ() + zOffset);
                BlockHitResult rayTraceResult = stateIn.getOcclusionShape((BlockGetter)worldIn, pos).clip(dropPos, dropPos.add(0.0, 1.0, 0.0), pos);
                if (rayTraceResult != null && rayTraceResult.getType() != HitResult.Type.MISS) {
                    Vec3 result = rayTraceResult.getLocation();
                    worldIn.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, result.x(), result.y() - 0.1, result.z(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

