/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.abyssaline;

import architectspalette.content.blocks.abyssaline.AbyssalineHelper;
import architectspalette.content.blocks.abyssaline.IAbyssalineChargeable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class NewAbyssalineBlock
extends Block
implements IAbyssalineChargeable {
    public static final BooleanProperty CHARGED = BooleanProperty.create((String)"charged");
    public static final DirectionProperty CHARGE_SOURCE = DirectionProperty.create((String)"charge_source", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});

    public NewAbyssalineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)CHARGED, (Comparable)Boolean.valueOf(false))).setValue((Property)CHARGE_SOURCE, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CHARGED, CHARGE_SOURCE});
    }

    public static int getLightValue(BlockState state) {
        return (Boolean)state.getValue((Property)CHARGED) != false ? 1 : 0;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        AbyssalineHelper.abyssalineNeighborUpdate(this, state, worldIn, pos, blockIn, fromPos);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        AbyssalineHelper.abyssalineTick(state, worldIn, pos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        context.getLevel().scheduleTick(context.getClickedPos(), (Block)this, 1);
        return this.defaultBlockState();
    }
}

