/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.abyssaline;

import architectspalette.content.blocks.abyssaline.AbyssalineBlock;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface IAbyssalineChargeable {
    public static final ImmutableMap<Direction, BlockPos> OFFSETS = new ImmutableMap.Builder().putAll(Arrays.stream(Direction.values()).collect(Collectors.toMap(a -> a, d -> new BlockPos(d.getNormal())))).build();

    default public boolean isCharged(BlockState stateIn) {
        return (Boolean)stateIn.getValue((Property)AbyssalineBlock.CHARGED);
    }

    default public Direction getSourceDirection(BlockState stateIn) {
        return (Direction)stateIn.getValue((Property)AbyssalineBlock.CHARGE_SOURCE);
    }

    default public boolean outputsChargeTo(BlockState stateIn, Direction faceIn) {
        return faceIn != this.getSourceDirection(stateIn) && this.isCharged(stateIn);
    }

    default public boolean acceptsChargeFrom(BlockState stateIn, Direction faceIn) {
        return true;
    }

    default public BlockPos getSourceOffset(BlockState stateIn) {
        return (BlockPos)OFFSETS.get((Object)this.getSourceDirection(stateIn));
    }

    default public BlockState getStateWithCharge(BlockState stateIn, boolean charged) {
        return (BlockState)stateIn.setValue((Property)AbyssalineBlock.CHARGED, (Comparable)Boolean.valueOf(charged));
    }

    default public BlockState getStateWithChargeDirection(BlockState stateIn, Direction directionToSource) {
        return (BlockState)stateIn.setValue((Property)AbyssalineBlock.CHARGE_SOURCE, (Comparable)directionToSource);
    }

    default public boolean pushesPower(BlockState stateIn) {
        return false;
    }

    default public boolean pullsPowerFrom(BlockState stateIn, Direction faceIn) {
        return false;
    }
}

