/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.abyssaline;

import architectspalette.content.blocks.abyssaline.AbyssalineBlock;
import architectspalette.content.blocks.abyssaline.IAbyssalineChargeable;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APSounds;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ChiseledAbyssalineBlock
extends Block
implements IAbyssalineChargeable {
    public static final Item KEY = Items.HEART_OF_THE_SEA;
    private static final BlockPos OFFSET = new BlockPos(0, 0, 0);

    @Override
    public boolean outputsChargeTo(BlockState stateIn, Direction faceIn) {
        return (Boolean)stateIn.getValue((Property)AbyssalineBlock.CHARGED);
    }

    @Override
    public boolean isCharged(BlockState stateIn) {
        return (Boolean)stateIn.getValue((Property)AbyssalineBlock.CHARGED);
    }

    @Override
    public BlockPos getSourceOffset(BlockState stateIn) {
        return OFFSET;
    }

    public ChiseledAbyssalineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AbyssalineBlock.CHARGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    public static int getLightValue(BlockState state) {
        return (Boolean)state.getValue((Property)AbyssalineBlock.CHARGED) != false ? 14 : 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AbyssalineBlock.CHARGED});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!this.isCharged(state) && stack.getItem() == KEY) {
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            world.setBlockAndUpdate(pos, this.getStateWithCharge(state, true));
            SoundEvent sound = this == APBlocks.CHISELED_HADALINE_BRICKS.get() ? APSounds.HADALINE_ACTIVATE.get() : SoundEvents.CONDUIT_ACTIVATE;
            world.playSound(null, pos, sound, SoundSource.BLOCKS, 0.5f, new Random().nextFloat() * 0.2f + 0.8f);
            return ItemInteractionResult.SUCCESS;
        }
        if (this.isCharged(state) && stack.isEmpty()) {
            world.setBlockAndUpdate(pos, this.getStateWithCharge(state, false));
            world.playSound(null, pos, SoundEvents.CONDUIT_DEACTIVATE, SoundSource.BLOCKS, 0.5f, new Random().nextFloat() * 0.2f + 0.8f);
            if (!player.isCreative() || player.getInventory().countItem(KEY) <= 0) {
                player.addItem(new ItemStack((ItemLike)KEY));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

