/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.abyssaline;

import architectspalette.content.blocks.VerticalSlabBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineHelper;
import architectspalette.content.blocks.abyssaline.IAbyssalineChargeable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class AbyssalineVerticalSlabBlock
extends VerticalSlabBlock
implements IAbyssalineChargeable {
    public AbyssalineVerticalSlabBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AbyssalineBlock.CHARGE_SOURCE, (Comparable)Direction.NORTH)).setValue((Property)AbyssalineBlock.CHARGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AbyssalineBlock.CHARGED, AbyssalineBlock.CHARGE_SOURCE, TYPE, WATERLOGGED});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return AbyssalineHelper.getStateWithNeighborCharge(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        AbyssalineHelper.abyssalineNeighborUpdate(this, state, worldIn, pos, blockIn, fromPos);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        AbyssalineHelper.abyssalineTick(state, worldIn, pos);
    }

    @Override
    public boolean acceptsChargeFrom(BlockState stateIn, Direction faceIn) {
        VerticalSlabBlock.VerticalSlabType type = (VerticalSlabBlock.VerticalSlabType)((Object)stateIn.getValue((Property)TYPE));
        return type == VerticalSlabBlock.VerticalSlabType.DOUBLE || faceIn != type.direction;
    }

    @Override
    public boolean outputsChargeTo(BlockState stateIn, Direction faceIn) {
        return IAbyssalineChargeable.super.outputsChargeTo(stateIn, faceIn) && this.acceptsChargeFrom(stateIn, faceIn);
    }

    @Override
    public BlockState getStateWithChargeDirection(BlockState stateIn, Direction directionToSource) {
        VerticalSlabBlock.VerticalSlabType type = (VerticalSlabBlock.VerticalSlabType)((Object)stateIn.getValue((Property)TYPE));
        if (type.direction == directionToSource) {
            return stateIn;
        }
        return (BlockState)stateIn.setValue((Property)AbyssalineBlock.CHARGE_SOURCE, (Comparable)directionToSource);
    }
}

