/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.abyssaline;

import architectspalette.content.blocks.abyssaline.AbyssalineBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineHelper;
import architectspalette.content.blocks.abyssaline.IAbyssalineChargeable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;

public class AbyssalineStairsBlock
extends StairBlock
implements IAbyssalineChargeable {
    public AbyssalineStairsBlock(BlockState state, BlockBehaviour.Properties properties) {
        super(state, properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AbyssalineBlock.CHARGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AbyssalineBlock.CHARGED, StairBlock.SHAPE, StairBlock.FACING, StairBlock.HALF, StairBlock.WATERLOGGED});
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.updateShape(state, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        AbyssalineHelper.abyssalineNeighborUpdate(this, state, worldIn, pos, blockIn, fromPos);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        AbyssalineHelper.abyssalineTick(state, worldIn, pos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return AbyssalineHelper.getStateWithNeighborCharge(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    @Override
    public boolean outputsChargeTo(BlockState stateIn, Direction faceIn) {
        boolean topface = stateIn.getValue((Property)StairBlock.HALF) == Half.TOP;
        boolean directionmatches = topface && faceIn == Direction.UP || !topface && faceIn == Direction.DOWN;
        return this.isCharged(stateIn) && directionmatches;
    }

    @Override
    public boolean acceptsChargeFrom(BlockState stateIn, Direction faceIn) {
        return faceIn == stateIn.getValue((Property)StairBlock.FACING);
    }

    @Override
    public Direction getSourceDirection(BlockState stateIn) {
        return (Direction)stateIn.getValue((Property)StairBlock.FACING);
    }

    @Override
    public BlockState getStateWithChargeDirection(BlockState stateIn, Direction directionToSource) {
        return stateIn;
    }
}

