/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.abyssaline;

import architectspalette.content.blocks.abyssaline.AbyssalineBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineHelper;
import architectspalette.content.blocks.abyssaline.IAbyssalineChargeable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class AbyssalinePillarBlock
extends RotatedPillarBlock
implements IAbyssalineChargeable {
    public AbyssalinePillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AbyssalineBlock.CHARGE_SOURCE, (Comparable)Direction.NORTH)).setValue((Property)AbyssalineBlock.CHARGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, AbyssalineBlock.CHARGED, AbyssalineBlock.CHARGE_SOURCE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return AbyssalineHelper.getStateWithNeighborCharge(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        AbyssalineHelper.abyssalineNeighborUpdate(this, state, worldIn, pos, blockIn, fromPos);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        AbyssalineHelper.abyssalineTick(state, worldIn, pos);
    }

    @Override
    public boolean acceptsChargeFrom(BlockState stateIn, Direction faceIn) {
        return faceIn.getAxis() == stateIn.getValue((Property)AXIS);
    }

    @Override
    public boolean outputsChargeTo(BlockState stateIn, Direction faceIn) {
        return this.isCharged(stateIn) && faceIn != this.getSourceDirection(stateIn) && faceIn.getAxis() == stateIn.getValue((Property)AXIS);
    }

    @Override
    public boolean pushesPower(BlockState stateIn) {
        return true;
    }

    @Override
    public boolean pullsPowerFrom(BlockState stateIn, Direction faceIn) {
        return faceIn.getAxis() == stateIn.getValue((Property)AXIS);
    }

    private static Direction directionFromAxis(Direction.Axis axis, Integer i) {
        switch (axis) {
            case X: {
                return i > 0 ? Direction.EAST : Direction.WEST;
            }
            case Y: {
                return i > 0 ? Direction.UP : Direction.DOWN;
            }
            case Z: {
                return i > 0 ? Direction.SOUTH : Direction.NORTH;
            }
        }
        return Direction.UP;
    }

    private PillarSide fromScalar(int integer) {
        return integer > 0 ? PillarSide.FRONT : PillarSide.BACK;
    }

    private static enum PillarSide implements StringRepresentable
    {
        FRONT,
        BACK;


        public int toScalar() {
            return this == FRONT ? 1 : -1;
        }

        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return this == FRONT ? "front" : "back";
        }
    }
}

