/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.abyssaline;

import architectspalette.content.blocks.NubBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineHelper;
import architectspalette.content.blocks.abyssaline.IAbyssalineChargeable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class AbyssalineNubBlock
extends NubBlock
implements IAbyssalineChargeable {
    public AbyssalineNubBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AbyssalineBlock.CHARGED, (Comparable)Boolean.FALSE));
    }

    public static int getLightValue(BlockState state) {
        return (Boolean)state.getValue((Property)AbyssalineBlock.CHARGED) != false ? 12 : 0;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return AbyssalineHelper.getStateWithNeighborCharge(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        AbyssalineHelper.abyssalineNeighborUpdate(this, state, worldIn, pos, blockIn, fromPos);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        AbyssalineHelper.abyssalineTick(state, worldIn, pos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AbyssalineBlock.CHARGED});
    }

    @Override
    public Direction getSourceDirection(BlockState stateIn) {
        return (Direction)stateIn.getValue((Property)FACING);
    }

    @Override
    public boolean outputsChargeTo(BlockState stateIn, Direction faceIn) {
        return false;
    }

    @Override
    public boolean acceptsChargeFrom(BlockState stateIn, Direction faceIn) {
        return faceIn == stateIn.getValue((Property)FACING);
    }

    @Override
    public BlockState getStateWithChargeDirection(BlockState stateIn, Direction directionToSource) {
        return stateIn;
    }

    @Override
    public boolean pullsPowerFrom(BlockState stateIn, Direction faceIn) {
        return faceIn == stateIn.getValue((Property)FACING);
    }
}

