/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.abyssaline;

import architectspalette.content.blocks.abyssaline.IAbyssalineChargeable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class AbyssalineHelper {
    public static final int CHARGE_LIGHT = 1;
    private static final int RECURSION_MAX = 12;

    public static boolean needsPostProcessing(BlockState stateIn, BlockGetter reader, BlockPos pos) {
        return ((IAbyssalineChargeable)stateIn.getBlock()).isCharged(stateIn);
    }

    public static boolean allowsMobSpawning(BlockState stateIn, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return !((IAbyssalineChargeable)stateIn.getBlock()).isCharged(stateIn);
    }

    public static boolean isAbyssaline(BlockState stateIn) {
        return stateIn.getBlock() instanceof IAbyssalineChargeable;
    }

    public static boolean getCharged(BlockState stateIn) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return false;
        }
        IAbyssalineChargeable block = (IAbyssalineChargeable)stateIn.getBlock();
        return block.isCharged(stateIn);
    }

    @Nullable
    private static IAbyssalineChargeable getAbyssaline(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof IAbyssalineChargeable) {
            IAbyssalineChargeable chargeable = (IAbyssalineChargeable)block;
            return chargeable;
        }
        return null;
    }

    public static boolean isValidConnection(BlockState unpoweredState, BlockState poweringState, Direction unpoweredFace) {
        IAbyssalineChargeable toCharge = AbyssalineHelper.getAbyssaline(unpoweredState);
        IAbyssalineChargeable chargeSource = AbyssalineHelper.getAbyssaline(poweringState);
        if (toCharge == null || chargeSource == null) {
            return false;
        }
        if (!chargeSource.isCharged(poweringState)) {
            return false;
        }
        if ((toCharge.acceptsChargeFrom(unpoweredState, unpoweredFace) || chargeSource.pushesPower(poweringState)) && (chargeSource.outputsChargeTo(poweringState, unpoweredFace.getOpposite()) || toCharge.pullsPowerFrom(unpoweredState, unpoweredFace))) {
            return toCharge.acceptsChargeFrom(toCharge.getStateWithChargeDirection(unpoweredState, unpoweredFace), unpoweredFace);
        }
        return false;
    }

    @Nullable
    public static BlockState getChargedState(BlockState stateIn, boolean charge) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return null;
        }
        return ((IAbyssalineChargeable)stateIn.getBlock()).getStateWithCharge(stateIn, charge);
    }

    @Nullable
    public static BlockState getStateWithChargeDirection(BlockState stateIn, Direction faceOut) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return null;
        }
        return ((IAbyssalineChargeable)stateIn.getBlock()).getStateWithChargeDirection(stateIn, faceOut);
    }

    public static boolean createsChargeLoop(BlockState startState, LevelAccessor world, BlockPos pos) {
        BlockPos.MutableBlockPos accumulator = new BlockPos(0, 0, 0).mutable();
        return AbyssalineHelper.checkForLoop(startState, world, pos, 12, accumulator, startState);
    }

    private static boolean checkForLoop(BlockState startState, LevelAccessor world, BlockPos pos, int tries, BlockPos.MutableBlockPos accumulator, BlockState chainStarter) {
        Direction facing;
        Block block = startState.getBlock();
        if (!(block instanceof IAbyssalineChargeable)) {
            return false;
        }
        IAbyssalineChargeable startBlock = (IAbyssalineChargeable)block;
        BlockPos offset = startBlock.getSourceOffset(startState);
        BlockPos nextPos = pos.offset((Vec3i)offset);
        if (nextPos == pos) {
            return false;
        }
        if (AbyssalineHelper.isAllZero((BlockPos)accumulator.move(offset.getX(), offset.getY(), offset.getZ()))) {
            return true;
        }
        BlockState nextState = world.getBlockState(nextPos);
        if (AbyssalineHelper.isMagnitudeOne((BlockPos)accumulator) && tries < 12 && AbyssalineHelper.isValidConnection(chainStarter, nextState, facing = AbyssalineHelper.directionFromOffset((BlockPos)accumulator))) {
            return true;
        }
        if (!AbyssalineHelper.getCharged(nextState)) {
            return true;
        }
        if (--tries > 0) {
            return AbyssalineHelper.checkForLoop(nextState, world, nextPos, tries, accumulator, chainStarter);
        }
        return false;
    }

    private static boolean isAllZero(BlockPos pos) {
        return pos.getY() == 0 && pos.getX() == 0 && pos.getZ() == 0;
    }

    private static boolean isMagnitudeOne(BlockPos pos) {
        return Math.abs(pos.getY()) + Math.abs(pos.getX()) + Math.abs(pos.getZ()) == 1;
    }

    private static Direction directionFromOffset(BlockPos pos) {
        int x = Math.abs(pos.getX());
        int y = Math.abs(pos.getY());
        int z = Math.abs(pos.getZ());
        int max = Math.max(Math.max(x, y), z);
        if (x == max) {
            return pos.getX() > 0 ? Direction.EAST : Direction.WEST;
        }
        if (y == max) {
            return pos.getY() > 0 ? Direction.UP : Direction.DOWN;
        }
        return pos.getZ() > 0 ? Direction.SOUTH : Direction.NORTH;
    }

    public static BlockState getStateWithNeighborCharge(BlockState stateIn, LevelAccessor world, BlockPos pos) {
        Direction source = null;
        boolean powered = false;
        for (Direction side : Direction.values()) {
            BlockPos offset = pos.relative(side);
            BlockState state = world.getBlockState(offset);
            if (!AbyssalineHelper.isValidConnection(stateIn, state, side) || AbyssalineHelper.createsChargeLoop(AbyssalineHelper.getStateWithChargeDirection(stateIn, side), world, pos)) continue;
            source = side;
            powered = true;
            break;
        }
        if (source != null) {
            return AbyssalineHelper.getChargedState(AbyssalineHelper.getStateWithChargeDirection(stateIn, source), powered);
        }
        return AbyssalineHelper.getChargedState(stateIn, false);
    }

    public static void abyssalineTick(BlockState state, ServerLevel worldIn, BlockPos pos) {
        BlockState newState = AbyssalineHelper.getStateWithNeighborCharge(state, (LevelAccessor)worldIn, pos);
        if (newState != state) {
            worldIn.setBlock(pos, newState, 7);
        }
    }

    public static void abyssalineNeighborUpdate(IAbyssalineChargeable thiz, BlockState stateIn, Level worldIn, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        boolean interested;
        boolean bl = interested = !thiz.isCharged(stateIn) && neighborBlock instanceof IAbyssalineChargeable || !AbyssalineHelper.isValidConnection(stateIn, worldIn.getBlockState(pos.offset((Vec3i)thiz.getSourceOffset(stateIn))), thiz.getSourceDirection(stateIn));
        if (neighborPos.equals((Object)pos.offset((Vec3i)thiz.getSourceOffset(stateIn))) || interested) {
            worldIn.scheduleTick(pos, (Block)thiz, 1);
        }
    }
}

