/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import architectspalette.core.integration.VerticalSlabs;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VerticalSlabBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.create((String)"type", VerticalSlabType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public VerticalSlabBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)VerticalSlabType.NORTH))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (!VerticalSlabs.areVisible()) {
            tooltip.add((Component)Component.translatable((String)"architects_palette.misc.no_quark").withStyle(ChatFormatting.RED));
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return state.getValue(TYPE) == VerticalSlabType.DOUBLE ? state : (BlockState)state.setValue(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(rot.rotate(((VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE))).direction))));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        VerticalSlabType type = (VerticalSlabType)((Object)state.getValue(TYPE));
        if (type == VerticalSlabType.DOUBLE || mirrorIn == Mirror.NONE) {
            return state;
        }
        if (mirrorIn == Mirror.LEFT_RIGHT && type.direction.getAxis() == Direction.Axis.Z || mirrorIn == Mirror.FRONT_BACK && type.direction.getAxis() == Direction.Axis.X) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(((VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE))).direction.getOpposite())));
        }
        return state;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, WATERLOGGED});
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ((VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE))).shape;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = context.getLevel().getBlockState(blockpos);
        if (blockstate.getBlock() == this) {
            return (BlockState)((BlockState)blockstate.setValue(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluid = context.getLevel().getFluidState(blockpos);
        BlockState retState = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
        Direction direction = this.getDirectionForPlacement(context);
        VerticalSlabType type = VerticalSlabType.fromDirection(direction);
        return (BlockState)retState.setValue(TYPE, (Comparable)((Object)type));
    }

    private Direction getDirectionForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        if (direction.getAxis() != Direction.Axis.Y) {
            return direction;
        }
        BlockPos pos = context.getClickedPos();
        Vec3 vec = context.getClickLocation().subtract(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).subtract(0.5, 0.0, 0.5);
        double angle = Math.atan2(vec.x, vec.z) * -180.0 / Math.PI;
        return Direction.fromYRot((double)angle).getOpposite();
    }

    public boolean canBeReplaced(BlockState state, @Nonnull BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        VerticalSlabType slabtype = (VerticalSlabType)((Object)state.getValue(TYPE));
        return slabtype != VerticalSlabType.DOUBLE && itemstack.getItem() == this.asItem() && (useContext.replacingClickedOnBlock() && useContext.getClickedFace() == slabtype.direction && this.getDirectionForPlacement(useContext) == slabtype.direction || !useContext.replacingClickedOnBlock() && useContext.getClickedFace().getAxis() != slabtype.direction.getAxis());
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean placeLiquid(@Nonnull LevelAccessor worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull FluidState fluidStateIn) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE && super.placeLiquid(worldIn, pos, state, fluidStateIn);
    }

    public boolean canPlaceLiquid(Player player, BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE && super.canPlaceLiquid(player, worldIn, pos, state, fluidIn);
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean isPathfindable(@Nonnull BlockState state, PathComputationType type) {
        return type == PathComputationType.WATER && state.getFluidState().is(FluidTags.WATER);
    }

    public static enum VerticalSlabType implements StringRepresentable
    {
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST),
        DOUBLE(null);

        public final Direction direction;
        public final VoxelShape shape;
        private final String name;

        private VerticalSlabType(Direction direction) {
            this.name = direction == null ? "double" : direction.getSerializedName();
            this.direction = direction;
            if (direction == null) {
                this.shape = Shapes.block();
            } else {
                double min = 0.0;
                double max = 8.0;
                if (direction.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
                    min = 8.0;
                    max = 16.0;
                }
                this.shape = direction.getAxis() == Direction.Axis.X ? Block.box((double)min, (double)0.0, (double)0.0, (double)max, (double)16.0, (double)16.0) : Block.box((double)0.0, (double)0.0, (double)min, (double)16.0, (double)16.0, (double)max);
            }
        }

        public static VerticalSlabType fromDirection(Direction direction) {
            for (VerticalSlabType type : VerticalSlabType.values()) {
                if (type.direction == null || direction != type.direction) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        @Nonnull
        public String getSerializedName() {
            return this.name;
        }
    }
}

