/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import architectspalette.content.blocks.TotemWingBlock;
import architectspalette.core.integration.APCriterion;
import architectspalette.core.registry.APBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class TotemBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public final TotemWingBlock WING_BLOCK;
    public final TotemFace totemType;

    public TotemBlock(BlockBehaviour.Properties properties, TotemWingBlock wingBlock, TotemFace face) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.WING_BLOCK = wingBlock;
        this.totemType = face;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (!worldIn.isClientSide) {
            boolean waterlogged;
            BlockPos blockpos = pos.relative(((Direction)state.getValue((Property)FACING)).getClockWise());
            boolean bl = waterlogged = worldIn.getFluidState(blockpos).getType() == Fluids.WATER;
            if (worldIn.isEmptyBlock(blockpos) || waterlogged) {
                worldIn.setBlock(blockpos, (BlockState)((BlockState)this.WING_BLOCK.defaultBlockState().setValue((Property)TotemWingBlock.FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getClockWise())).setValue((Property)TotemWingBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 3);
            }
            boolean bl2 = waterlogged = worldIn.getFluidState(blockpos = pos.relative(((Direction)state.getValue((Property)FACING)).getCounterClockWise())).getType() == Fluids.WATER;
            if (worldIn.isEmptyBlock(blockpos) || waterlogged) {
                worldIn.setBlock(blockpos, (BlockState)((BlockState)this.WING_BLOCK.defaultBlockState().setValue((Property)TotemWingBlock.FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getCounterClockWise())).setValue((Property)TotemWingBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 3);
            }
            worldIn.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)worldIn, pos, 3);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof AxeItem) {
            BlockState newState = (BlockState)this.totemType.getStrip().defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
            world.setBlock(pos, newState, 3);
            stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            world.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                APCriterion.CARVE_TOTEM.get().trigger((ServerPlayer)player);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return ItemInteractionResult.FAIL;
    }

    public static enum TotemFace {
        GRINNING,
        PLACID,
        SHOCKED,
        BLANK;


        public Block getStrip() {
            return switch (this.ordinal()) {
                case 0 -> APBlocks.PLACID_ACACIA_TOTEM.get();
                case 1 -> APBlocks.SHOCKED_ACACIA_TOTEM.get();
                case 2 -> APBlocks.BLANK_ACACIA_TOTEM.get();
                default -> APBlocks.GRINNING_ACACIA_TOTEM.get();
            };
        }
    }
}

