/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import architectspalette.core.config.APConfig;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class SunstoneBlock
extends Block {
    public static final IntegerProperty LIGHT = IntegerProperty.create((String)"light", (int)0, (int)2);
    public Function<Level, Integer> lightSupplier;

    public SunstoneBlock(BlockBehaviour.Properties properties, Function<Level, Integer> getLightState) {
        super(properties);
        this.lightSupplier = getLightState;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIGHT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIGHT, (Comparable)this.lightSupplier.apply(context.getLevel()));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        Integer lightstate;
        if (!worldIn.isClientSide && !(lightstate = this.lightSupplier.apply((Level)worldIn)).equals(state.getValue((Property)LIGHT))) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)LIGHT, (Comparable)lightstate), 6);
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        RandomSource rand;
        Double chance;
        if (facingState.getBlock() instanceof SunstoneBlock && (chance = (Double)APConfig.SUNSTONE_SPREAD_CHANCE.get()) > 0.0 && (rand = worldIn.getRandom()).nextDouble() <= chance) {
            worldIn.scheduleTick(currentPos, (Block)this, (int)(2.0 + Math.floor(rand.nextDouble() * 6.0)));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public static Integer sunstoneLight(Level world) {
        return SunstoneBlock.getLightFromTime(world, 0L);
    }

    public static Integer moonstoneLight(Level world) {
        return SunstoneBlock.getLightFromTime(world, 12000L);
    }

    private static Integer getLightFromTime(Level world, long offset) {
        MinecraftServer s = world.getServer();
        if (s == null) {
            return 0;
        }
        ServerLevel overworld = s.getLevel(Level.OVERWORLD);
        if (overworld != null) {
            long time = (overworld.getDayTime() + offset) % 24000L;
            if (time >= 12500L && time <= 23500L) {
                return 0;
            }
            if (time >= 3500L && time <= 8500L) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static boolean isOpaque(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Integer)state.getValue((Property)LIGHT) == 0;
    }

    public static boolean isLit(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Integer)state.getValue((Property)LIGHT) != 0;
    }

    public static int lightValue(BlockState state) {
        return (Integer)state.getValue((Property)LIGHT) * 7;
    }
}

