/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import architectspalette.core.util.ShapeRotator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipeBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<PipeBlockPart> PART = EnumProperty.create((String)"part", PipeBlockPart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape Y_AXIS_SHAPE = ShapeRotator.cutout(Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
    protected static final VoxelShape Z_AXIS_SHAPE = ShapeRotator.cutout(Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0));
    protected static final VoxelShape X_AXIS_SHAPE = ShapeRotator.cutout(Block.box((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));

    public PipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)Direction.Axis.Y)).setValue(PART, (Comparable)((Object)PipeBlockPart.MIDDLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, PART, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.getValue((Property)AXIS)) {
            default: {
                return X_AXIS_SHAPE;
            }
            case Z: {
                return Z_AXIS_SHAPE;
            }
            case Y: 
        }
        return Y_AXIS_SHAPE;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.block();
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return (BlockState)state.setValue(PART, (Comparable)((Object)this.checkNearbyPipes(state, worldIn, currentPos)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        BlockState b = super.getStateForPlacement(context);
        return (BlockState)((BlockState)b.setValue(PART, (Comparable)((Object)this.checkNearbyPipes(b, (LevelAccessor)context.getLevel(), context.getClickedPos())))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public PipeBlockPart checkNearbyPipes(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction.Axis facing = (Direction.Axis)state.getValue((Property)AXIS);
        BlockPos forward = pos.relative(facing, 1);
        BlockPos reverse = pos.relative(facing, -1);
        boolean ffound = this.pipeMatches(state, world.getBlockState(forward));
        boolean rfound = this.pipeMatches(state, world.getBlockState(reverse));
        if (facing == Direction.Axis.Z) {
            boolean e = ffound;
            ffound = rfound;
            rfound = e;
        }
        if (ffound && rfound) {
            return PipeBlockPart.MIDDLE;
        }
        if (ffound) {
            return PipeBlockPart.BOTTOM;
        }
        return PipeBlockPart.TOP;
    }

    private boolean pipeMatches(BlockState base, BlockState checking) {
        return checking.getBlock() instanceof PipeBlock && checking.getValue((Property)AXIS) == base.getValue((Property)AXIS);
    }

    public static enum PipeBlockPart implements StringRepresentable
    {
        TOP,
        MIDDLE,
        BOTTOM;


        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            switch (this.ordinal()) {
                case 0: {
                    return "top";
                }
                case 2: {
                    return "bottom";
                }
            }
            return "middle";
        }
    }
}

