/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import architectspalette.core.registry.APTags;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class GreenFireBlock
extends BaseFireBlock {
    public static final MapCodec<GreenFireBlock> CODEC = GreenFireBlock.simpleCodec(GreenFireBlock::new);

    public GreenFireBlock(BlockBehaviour.Properties properties) {
        super(properties, 3.0f);
    }

    protected MapCodec<? extends GreenFireBlock> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)Items.FLINT_AND_STEEL);
    }

    public BlockState updateShape(BlockState state, Direction face, BlockState facingState, LevelAccessor levelAccessor, BlockPos thisPos, BlockPos facingPos) {
        return this.canSurvive(state, (LevelReader)levelAccessor, thisPos) ? this.defaultBlockState() : Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(BlockState stateIn, LevelReader levelReader, BlockPos pos) {
        return GreenFireBlock.canHeGreen((BlockGetter)levelReader, pos.below());
    }

    public static boolean canHeGreen(BlockGetter getter, BlockPos pos) {
        BlockState state = getter.getBlockState(pos);
        return state.is(APTags.GREEN_FIRE_SUPPORTING) && state.isFaceSturdy(getter, pos, Direction.UP);
    }

    protected boolean canBurn(BlockState p_49284_) {
        return true;
    }
}

