/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import architectspalette.content.blocks.StrippableBlock;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.util.BlockNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BreadBlock
extends Block
implements StrippableBlock {
    public static final EnumProperty<BreadPart> PART = EnumProperty.create((String)"part", BreadPart.class);

    @Override
    public Block getStripToBlock() {
        return APBlocks.BREAD_BLOCK.getChild(BlockNode.BlockType.SPECIAL).get();
    }

    public BreadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).setValue(PART, (Comparable)((Object)BreadPart.WHOLE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PART, BlockStateProperties.HORIZONTAL_AXIS});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] directions;
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return state;
        }
        Direction dir = context.getHorizontalDirection();
        BlockPos placePos = context.getClickedPos();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (Direction direction : directions = new Direction[]{dir, dir.getOpposite(), dir.getClockWise(), dir.getCounterClockWise()}) {
            BlockState test = context.getLevel().getBlockState((BlockPos)pos.setWithOffset((Vec3i)placePos, direction));
            if (!test.is((Block)this) || !this.canConnect(state, direction) || !this.canConnect(test, direction.getOpposite())) continue;
            state = this.connectTo(state, direction);
        }
        return state;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (facing != Direction.UP && facing != Direction.DOWN && facingState.is((Block)this) && this.canConnect(state, facing) && this.canConnect(facingState, facing.getOpposite())) {
            return this.connectTo(state, facing);
        }
        return state;
    }

    private BlockState connectTo(BlockState state, Direction direction) {
        Direction.AxisDirection dir;
        BreadPart part = (BreadPart)((Object)state.getValue(PART));
        if (part == BreadPart.WHOLE) {
            part = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ? BreadPart.RIGHT : BreadPart.LEFT;
            return (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)part))).setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)direction.getAxis());
        }
        Direction.AxisDirection axisDirection = dir = part == BreadPart.LEFT ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        if ((part == BreadPart.LEFT || part == BreadPart.RIGHT) && direction.getAxisDirection() == dir) {
            part = BreadPart.MIDDLE;
            return (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)part))).setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)direction.getAxis());
        }
        return state;
    }

    private boolean canConnect(BlockState state, Direction connectTo) {
        BreadPart part = (BreadPart)((Object)state.getValue(PART));
        if (part == BreadPart.WHOLE) {
            return true;
        }
        return connectTo.getAxis() == state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
    }

    public static enum BreadPart implements StringRepresentable
    {
        LEFT,
        MIDDLE,
        RIGHT,
        WHOLE;


        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "left";
                case 1 -> "middle";
                case 2 -> "right";
                case 3 -> "whole";
            };
        }
    }
}

