/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BigBrickBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty PAIRED = BooleanProperty.create((String)"paired");
    public final BrickType TYPE;

    public BigBrickBlock(BlockBehaviour.Properties properties) {
        this(properties, BrickType.STONE);
    }

    public BigBrickBlock(BlockBehaviour.Properties properties, BrickType type) {
        super(properties);
        this.TYPE = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.DOWN)).setValue((Property)PAIRED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction face = context.getClickedFace();
        BlockPos targetPos = context.getClickedPos().relative(face.getOpposite());
        BlockState targetState = context.getLevel().getBlockState(targetPos);
        boolean pairing = context.getPlayer() != null && !context.getPlayer().isShiftKeyDown() && this.BrickMatches(this, targetState) && (Boolean)targetState.getValue((Property)PAIRED) == false;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)PAIRED, (Comparable)Boolean.valueOf(pairing));
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (!worldIn.isClientSide) {
            if (placer != null && placer.isShiftKeyDown()) {
                return;
            }
            BlockPos blockpos = pos.relative((Direction)state.getValue((Property)FACING));
            BlockState blockstate = worldIn.getBlockState(blockpos);
            if (this.BrickMatches(this, blockstate) && !((Boolean)blockstate.getValue((Property)PAIRED)).booleanValue()) {
                worldIn.setBlock(blockpos, (BlockState)((BlockState)blockstate.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getOpposite())).setValue((Property)PAIRED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.blockUpdated(pos, Blocks.AIR);
                state.updateNeighbourShapes((LevelAccessor)worldIn, pos, 3);
            }
        }
    }

    private boolean BrickMatches(BigBrickBlock thisBlock, BlockState suspect) {
        Block block = suspect.getBlock();
        if (block instanceof BigBrickBlock) {
            BigBrickBlock block2 = (BigBrickBlock)block;
            return block2.TYPE == thisBlock.TYPE;
        }
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.equals((Object)stateIn.getValue((Property)FACING)) && ((Boolean)stateIn.getValue((Property)PAIRED)).booleanValue() && !this.BrickMatches(this, worldIn.getBlockState(facingPos))) {
            return (BlockState)stateIn.setValue((Property)PAIRED, (Comparable)Boolean.valueOf(false));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PAIRED});
    }

    public static enum BrickType {
        STONE,
        END_STONE,
        DRIPSTONE,
        CALCITE,
        TUFF;

    }
}

