/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.compat.jei;

import architectspalette.compat.jei.JEIPlugin;
import architectspalette.core.APConstants;
import architectspalette.core.crafting.WarpingRecipe;
import architectspalette.core.registry.APBlocks;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class WarpingRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<WarpingRecipe>> {
    private final IDrawable background;
    public static int WIDTH = 117;
    public static int HEIGHT = 57;

    public WarpingRecipeCategory(IGuiHelper helper) {
        super(JEIPlugin.WARPING.get(), (Component)Component.translatable((String)"architects_palette.info.warping_recipe_title"), helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)APBlocks.WARPSTONE.get())), WIDTH, HEIGHT);
        this.background = helper.createDrawable(APConstants.rl("textures/gui/warping_recipe.png"), 0, 0, WIDTH, HEIGHT);
    }

    public void draw(@NotNull RecipeHolder<WarpingRecipe> recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.background.draw(guiGraphics, 0, 0);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<WarpingRecipe> recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 22).addItemStacks(Arrays.asList(((WarpingRecipe)recipe.value()).getInput().getItems()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 87, 22).addItemStack(((WarpingRecipe)recipe.value()).getResult());
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, @NotNull RecipeHolder<WarpingRecipe> recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, recipe, recipeSlotsView, mouseX, mouseY);
        if (WarpingRecipeCategory.pointInBox(mouseX, mouseY, 49.0, 12.0, 18.0, 35.0)) {
            ResourceLocation targetDimension = ((WarpingRecipe)recipe.value()).getDimension();
            MutableComponent dimensionName = Component.translatable((String)("architects_palette.info.dimension." + targetDimension.toString().replace(":", ".")));
            MutableComponent tossPrompt = Component.translatable((String)"architects_palette.info.warping_toss_description", (Object[])new Object[]{dimensionName});
            tooltip.add((FormattedText)tossPrompt);
        }
    }

    private static boolean pointInBox(double x, double y, double left, double top, double width, double height) {
        return x >= left && x <= left + width && y >= top && y <= top + height;
    }
}

