/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.compat.jei;

import architectspalette.compat.BlockInfoBuilder;
import architectspalette.compat.jei.WarpingRecipeCategory;
import architectspalette.content.blocks.BigBrickBlock;
import architectspalette.content.blocks.CageLanternBlock;
import architectspalette.content.blocks.VerticalSlabBlock;
import architectspalette.core.APConstants;
import architectspalette.core.crafting.WarpingRecipe;
import architectspalette.core.integration.VerticalSlabs;
import architectspalette.core.platform.Services;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APRecipes;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final Supplier<RecipeType<RecipeHolder<WarpingRecipe>>> WARPING = () -> RecipeType.createFromVanilla(APRecipes.WARPING.get());
    protected static final ResourceLocation PLUGIN_ID = APConstants.rl("jei_plugin");

    protected static BlockInfoBuilder builder(IRecipeRegistration register) {
        return new BlockInfoBuilder((ingredients, text, id) -> register.addIngredientInfo(ingredients, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{text}));
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new WarpingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        if (!VerticalSlabs.areVisible()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Services.REGISTRY.getModBlocks().stream().filter(b -> b instanceof VerticalSlabBlock).map(ItemStack::new).toList());
        }
        assert (Minecraft.getInstance().level != null);
        registration.addRecipes(WARPING.get(), Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(APRecipes.WARPING.get()));
        JEIPlugin.builder(registration).add(APBlocks.CHISELED_ABYSSALINE_BRICKS, APBlocks.CHISELED_HADALINE_BRICKS).registerInfo("chiseled_chargeable");
        JEIPlugin.builder(registration).add(APBlocks.ABYSSALINE, APBlocks.ABYSSALINE_PILLAR, APBlocks.ABYSSALINE_LAMP_BLOCK, APBlocks.ABYSSALINE_PLATING).add(APBlocks.ABYSSALINE_BRICKS, APBlocks.ABYSSALINE_TILES).add(APBlocks.HADALINE, APBlocks.HADALINE_PILLAR, APBlocks.HADALINE_LAMP_BLOCK, APBlocks.HADALINE_PLATING).add(APBlocks.HADALINE_BRICKS, APBlocks.HADALINE_TILES).registerInfo("chargeable");
        JEIPlugin.builder(registration).add(APBlocks.PLACID_ACACIA_TOTEM, APBlocks.GRINNING_ACACIA_TOTEM, APBlocks.SHOCKED_ACACIA_TOTEM, APBlocks.BLANK_ACACIA_TOTEM).registerInfo("totem_carving");
        JEIPlugin.builder(registration).add(APBlocks.FLINT_BLOCK, APBlocks.FLINT_PILLAR).add(APBlocks.FLINT_TILES).registerInfo("flint_damage");
        JEIPlugin.builder(registration).add(APBlocks.MOONSTONE, APBlocks.SUNSTONE).registerInfo("celestial_stones");
        JEIPlugin.builder(registration).add(APBlocks.NETHER_BRASS, APBlocks.CUT_NETHER_BRASS, APBlocks.SMOOTH_NETHER_BRASS).add(APBlocks.NETHER_BRASS_PILLAR).registerInfo("nether_brass");
        JEIPlugin.builder(registration).add(block -> block instanceof BigBrickBlock).registerInfo("heavy_bricks");
        JEIPlugin.builder(registration).add(block -> block instanceof CageLanternBlock).registerInfo("cage_lanterns");
        JEIPlugin.builder(registration).add(APBlocks.WARDSTONE, APBlocks.WARDSTONE_BRICKS).add(APBlocks.WARDSTONE_PILLAR, APBlocks.CHISELED_WARDSTONE, APBlocks.WARDSTONE_LAMP).registerInfo("wardstone");
    }
}

