/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.compat.emi;

import architectspalette.compat.emi.EMIPlugin;
import architectspalette.core.APConstants;
import architectspalette.core.crafting.WarpingRecipe;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;

public class WarpingEMIRecipe
extends BasicEmiRecipe {
    private final RecipeHolder<WarpingRecipe> RECIPE;
    public static final EmiTexture PORTAL_TEXTURE = new EmiTexture(APConstants.rl("textures/gui/warping_recipe.png"), 0, 0, 117, 57);

    public WarpingEMIRecipe(RecipeHolder<WarpingRecipe> recipe) {
        super(EMIPlugin.WARPING_CATEGORY, recipe.id(), 117, 57);
        this.RECIPE = recipe;
        this.inputs.add(EmiIngredient.of((Ingredient)((WarpingRecipe)recipe.value()).getInput()));
        this.outputs.add(EmiStack.of((ItemStack)((WarpingRecipe)recipe.value()).getResult()));
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(PORTAL_TEXTURE, 0, 0);
        widgets.addSlot((EmiIngredient)this.inputs.getFirst(), 16, 22);
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 87, 22).recipeContext((EmiRecipe)this);
        MutableComponent dimensionName = Component.translatable((String)("architects_palette.info.dimension." + ((WarpingRecipe)this.RECIPE.value()).getDimension().toString().replace(":", ".")));
        MutableComponent tossPrompt = Component.translatable((String)"architects_palette.info.warping_toss_description", (Object[])new Object[]{dimensionName});
        widgets.addTooltipText(List.of(tossPrompt), 49, 12, 18, 35);
    }
}

