/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.compat.emi;

import architectspalette.compat.BlockInfoBuilder;
import architectspalette.compat.emi.WarpingEMIRecipe;
import architectspalette.content.blocks.BigBrickBlock;
import architectspalette.content.blocks.CageLanternBlock;
import architectspalette.core.APConstants;
import architectspalette.core.crafting.WarpingRecipe;
import architectspalette.core.integration.VerticalSlabs;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APRecipes;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class EMIPlugin
implements EmiPlugin {
    static final EmiStack ICON = EmiStack.of((ItemLike)APBlocks.WARPSTONE.get());
    public static final EmiRecipeCategory WARPING_CATEGORY = new EmiRecipeCategory(APConstants.rl("warping"), (EmiRenderable)ICON, (EmiRenderable)ICON);

    public void register(EmiRegistry registry) {
        registry.removeEmiStacks(it -> !VerticalSlabs.isVisible((ItemLike)it.getItemStack().getItem()));
        registry.addCategory(WARPING_CATEGORY);
        RecipeManager manager = registry.getRecipeManager();
        for (RecipeHolder recipe : manager.getAllRecipesFor(APRecipes.WARPING.get())) {
            registry.addRecipe((EmiRecipe)new WarpingEMIRecipe((RecipeHolder<WarpingRecipe>)recipe));
        }
        EMIPlugin.builder(registry).add(APBlocks.CHISELED_ABYSSALINE_BRICKS, APBlocks.CHISELED_HADALINE_BRICKS).registerInfo("chiseled_chargeable");
        EMIPlugin.builder(registry).add(APBlocks.ABYSSALINE, APBlocks.ABYSSALINE_PILLAR, APBlocks.ABYSSALINE_LAMP_BLOCK, APBlocks.ABYSSALINE_PLATING).add(APBlocks.ABYSSALINE_BRICKS, APBlocks.ABYSSALINE_TILES).add(APBlocks.HADALINE, APBlocks.HADALINE_PILLAR, APBlocks.HADALINE_LAMP_BLOCK, APBlocks.HADALINE_PLATING).add(APBlocks.HADALINE_BRICKS, APBlocks.HADALINE_TILES).registerInfo("chargeable");
        EMIPlugin.builder(registry).add(APBlocks.PLACID_ACACIA_TOTEM, APBlocks.GRINNING_ACACIA_TOTEM, APBlocks.SHOCKED_ACACIA_TOTEM, APBlocks.BLANK_ACACIA_TOTEM).registerInfo("totem_carving");
        EMIPlugin.builder(registry).add(APBlocks.FLINT_BLOCK, APBlocks.FLINT_PILLAR).add(APBlocks.FLINT_TILES).registerInfo("flint_damage");
        EMIPlugin.builder(registry).add(APBlocks.MOONSTONE, APBlocks.SUNSTONE).registerInfo("celestial_stones");
        EMIPlugin.builder(registry).add(APBlocks.NETHER_BRASS, APBlocks.CUT_NETHER_BRASS, APBlocks.SMOOTH_NETHER_BRASS).add(APBlocks.NETHER_BRASS_PILLAR).registerInfo("nether_brass");
        EMIPlugin.builder(registry).add(block -> block instanceof BigBrickBlock).registerInfo("heavy_bricks");
        EMIPlugin.builder(registry).add(block -> block instanceof CageLanternBlock).registerInfo("cage_lanterns");
        EMIPlugin.builder(registry).add(APBlocks.WARDSTONE, APBlocks.WARDSTONE_BRICKS).add(APBlocks.WARDSTONE_PILLAR, APBlocks.CHISELED_WARDSTONE, APBlocks.WARDSTONE_LAMP).registerInfo("wardstone");
    }

    protected static BlockInfoBuilder builder(EmiRegistry register) {
        return new BlockInfoBuilder((ingredients, text, id) -> register.addRecipe((EmiRecipe)new EmiInfoRecipe(ingredients.stream().map(i -> EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{i}))).toList(), List.of(text), id)));
    }
}

