/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.compat;

import architectspalette.core.APConstants;
import architectspalette.core.integration.VerticalSlabs;
import architectspalette.core.platform.Services;
import architectspalette.core.registry.util.BlockNode;
import architectspalette.core.registry.util.StoneBlockSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class BlockInfoBuilder {
    public final List<Block> blocks = new ArrayList<Block>();
    public final InfoRecipeRegistrar registrar;

    public BlockInfoBuilder(InfoRecipeRegistrar registrar) {
        this.registrar = registrar;
    }

    public BlockInfoBuilder add(BlockNode ... nodes) {
        for (BlockNode node : nodes) {
            node.forEach(n -> this.blocks.add(n.get()));
        }
        return this;
    }

    public BlockInfoBuilder add(StoneBlockSet ... sets) {
        for (StoneBlockSet set : sets) {
            set.forEach(this.blocks::add);
        }
        return this;
    }

    public BlockInfoBuilder add(Predicate<Block> filter) {
        for (Block block : Services.REGISTRY.getModBlocks()) {
            if (!filter.test(block)) continue;
            this.blocks.add(block);
        }
        return this;
    }

    @SafeVarargs
    public final BlockInfoBuilder add(Supplier<? extends Block> ... blockList) {
        for (Supplier<? extends Block> block : blockList) {
            this.blocks.add(block.get());
        }
        return this;
    }

    public void registerInfo(String infoString) {
        List<ItemStack> items = this.blocks.stream().filter(VerticalSlabs::isVisible).map(ItemStack::new).toList();
        MutableComponent text = Component.translatable((String)("architects_palette.info." + infoString));
        this.registrar.register(items, (Component)text, APConstants.rl("/info/" + infoString));
        this.blocks.clear();
    }

    public static interface InfoRecipeRegistrar {
        public void register(List<ItemStack> var1, Component var2, ResourceLocation var3);
    }
}

