/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.client;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.client.AbstractDynamicBakedModel;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.cables.client.CablePatterns;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class GenericCableBakedModel
extends AbstractDynamicBakedModel {
    private TextureAtlasSprite spriteCable;
    private static CableTextures[] cableTextures = null;
    private static TextureAtlasSprite spriteSide;

    private static void initTextures() {
        if (cableTextures == null) {
            CableTextures[] tt = new CableTextures[CableColor.VALUES.length];
            for (CableColor color : CableColor.VALUES) {
                int i = color.ordinal();
                tt[i] = new CableTextures();
                tt[i].spriteConnector = GenericCableBakedModel.getTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)("block/cable" + i + "/connector")));
                tt[i].spriteAdvancedConnector = GenericCableBakedModel.getTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)("block/cable" + i + "/advanced_connector")));
                tt[i].spriteNormalCable = GenericCableBakedModel.getTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)("block/cable" + i + "/normal_netcable")));
                tt[i].spriteNoneCable = GenericCableBakedModel.getTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)("block/cable" + i + "/normal_none_netcable")));
                tt[i].spriteEndCable = GenericCableBakedModel.getTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)("block/cable" + i + "/normal_end_netcable")));
                tt[i].spriteCornerCable = GenericCableBakedModel.getTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)("block/cable" + i + "/normal_corner_netcable")));
                tt[i].spriteThreeCable = GenericCableBakedModel.getTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)("block/cable" + i + "/normal_three_netcable")));
                tt[i].spriteCrossCable = GenericCableBakedModel.getTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)("block/cable" + i + "/normal_cross_netcable")));
            }
            spriteSide = GenericCableBakedModel.getTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)"block/connector_side"));
            cableTextures = tt;
        }
    }

    private static TextureAtlasSprite getSpriteNormal(CablePatterns.SpriteIdx idx, int index) {
        GenericCableBakedModel.initTextures();
        CableTextures cableTexture = cableTextures[index];
        return switch (idx) {
            default -> throw new MatchException(null, null);
            case CablePatterns.SpriteIdx.SPRITE_NONE -> cableTexture.spriteNoneCable;
            case CablePatterns.SpriteIdx.SPRITE_END -> cableTexture.spriteEndCable;
            case CablePatterns.SpriteIdx.SPRITE_STRAIGHT -> cableTexture.spriteNormalCable;
            case CablePatterns.SpriteIdx.SPRITE_CORNER -> cableTexture.spriteCornerCable;
            case CablePatterns.SpriteIdx.SPRITE_THREE -> cableTexture.spriteThreeCable;
            case CablePatterns.SpriteIdx.SPRITE_CROSS -> cableTexture.spriteCrossCable;
        };
    }

    private BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, int rotation, float hilight) {
        return switch (rotation) {
            case 0 -> this.createQuad(v1, v2, v3, v4, sprite, hilight);
            case 1 -> this.createQuad(v2, v3, v4, v1, sprite, hilight);
            case 2 -> this.createQuad(v3, v4, v1, v2, sprite, hilight);
            case 3 -> this.createQuad(v4, v1, v2, v3, sprite, hilight);
            default -> this.createQuad(v1, v2, v3, v4, sprite, hilight);
        };
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType layer) {
        BlockState facadeId;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side == null && (layer == null || layer.equals(RenderType.solid()))) {
            CablePatterns.QuadSetting pattern;
            ConnectorType north = (ConnectorType)((Object)state.getValue(GenericCableBlock.NORTH));
            ConnectorType south = (ConnectorType)((Object)state.getValue(GenericCableBlock.SOUTH));
            ConnectorType west = (ConnectorType)((Object)state.getValue(GenericCableBlock.WEST));
            ConnectorType east = (ConnectorType)((Object)state.getValue(GenericCableBlock.EAST));
            ConnectorType up = (ConnectorType)((Object)state.getValue(GenericCableBlock.UP));
            ConnectorType down = (ConnectorType)((Object)state.getValue(GenericCableBlock.DOWN));
            CableColor cableColor = (CableColor)((Object)state.getValue(GenericCableBlock.COLOR));
            int index = cableColor.ordinal();
            GenericCableBakedModel.initTextures();
            CableTextures ct = cableTextures[index];
            this.spriteCable = ct.spriteNormalCable;
            GenericCableBlock block = (GenericCableBlock)state.getBlock();
            TextureAtlasSprite spriteConnector = block.isAdvancedConnector() ? ct.spriteAdvancedConnector : ct.spriteConnector;
            Function getSprite = idx -> GenericCableBakedModel.getSpriteNormal(idx, index);
            float hilight = 1.0f;
            if (block instanceof ConnectorBlock && north != ConnectorType.BLOCK && south != ConnectorType.BLOCK && west != ConnectorType.BLOCK && east != ConnectorType.BLOCK && up != ConnectorType.BLOCK && down != ConnectorType.BLOCK) {
                hilight = 0.5f;
            }
            double o = 0.4;
            double p = 0.1;
            double q = 0.2;
            if (up == ConnectorType.CABLE) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)1.0, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)1.0, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)1.0, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)1.0, (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)1.0, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)1.0, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)1.0, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)1.0, (double)(1.0 - o)), this.spriteCable, hilight));
            } else if (up == ConnectorType.BLOCK) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - p), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - p), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - p), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - p), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - p), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - p), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - p), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - p), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - p), (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)1.0, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)1.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - p), (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - p), (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)1.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)1.0, (double)q), GenericCableBakedModel.v((double)q, (double)(1.0 - p), (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)1.0, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)1.0, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - p), (double)q), GenericCableBakedModel.v((double)q, (double)(1.0 - p), (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - p), (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - p), (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)1.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)1.0, (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - p), (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - p), (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - p), (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)(1.0 - p), (double)(1.0 - q)), spriteConnector, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)1.0, (double)q), GenericCableBakedModel.v((double)q, (double)1.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)1.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)1.0, (double)q), spriteSide, hilight));
            } else {
                pattern = CablePatterns.findPattern(west, south, east, north);
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
            }
            if (down == ConnectorType.CABLE) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)0.0, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)0.0, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)0.0, (double)o), GenericCableBakedModel.v((double)o, (double)0.0, (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)0.0, (double)o), GenericCableBakedModel.v((double)o, (double)0.0, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)0.0, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)0.0, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
            } else if (down == ConnectorType.BLOCK) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)p, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)p, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)p, (double)o), GenericCableBakedModel.v((double)o, (double)p, (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)p, (double)o), GenericCableBakedModel.v((double)o, (double)p, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)p, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)p, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - q), (double)0.0, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)p, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)p, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)0.0, (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)0.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)p, (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)p, (double)q), GenericCableBakedModel.v((double)q, (double)0.0, (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)p, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)p, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)0.0, (double)q), GenericCableBakedModel.v((double)q, (double)0.0, (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)0.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)0.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)p, (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)p, (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)p, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)p, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)p, (double)q), GenericCableBakedModel.v((double)q, (double)p, (double)q), spriteConnector, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)0.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)0.0, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)0.0, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)0.0, (double)(1.0 - q)), spriteSide, hilight));
            } else {
                pattern = CablePatterns.findPattern(west, north, east, south);
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
            }
            if (east == ConnectorType.CABLE) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)1.0, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)1.0, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)1.0, (double)o, (double)o), GenericCableBakedModel.v((double)1.0, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)1.0, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)1.0, (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)1.0, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)1.0, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
            } else if (east == ConnectorType.BLOCK) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - p), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - p), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)1.0, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)1.0, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - q), (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)q, (double)q), GenericCableBakedModel.v((double)1.0, (double)q, (double)q), GenericCableBakedModel.v((double)1.0, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - p), (double)q, (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)1.0, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)1.0, (double)q, (double)q), GenericCableBakedModel.v((double)(1.0 - p), (double)q, (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)1.0, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)1.0, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - q), (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)(1.0 - p), (double)q, (double)q), spriteConnector, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)1.0, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)1.0, (double)q, (double)q), GenericCableBakedModel.v((double)1.0, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)1.0, (double)(1.0 - q), (double)(1.0 - q)), spriteSide, hilight));
            } else {
                pattern = CablePatterns.findPattern(down, north, up, south);
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
            }
            if (west == ConnectorType.CABLE) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)0.0, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)0.0, (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)0.0, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)0.0, (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)0.0, (double)o, (double)o), GenericCableBakedModel.v((double)0.0, (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)0.0, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)0.0, (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
            } else if (west == ConnectorType.BLOCK) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)p, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)p, (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)p, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)p, (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)p, (double)o, (double)o), GenericCableBakedModel.v((double)p, (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)p, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)p, (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)0.0, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)p, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)p, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)0.0, (double)(1.0 - q), (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)0.0, (double)q, (double)q), GenericCableBakedModel.v((double)p, (double)q, (double)q), GenericCableBakedModel.v((double)p, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)0.0, (double)q, (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)0.0, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)p, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)p, (double)q, (double)q), GenericCableBakedModel.v((double)0.0, (double)q, (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)0.0, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)p, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)p, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)0.0, (double)(1.0 - q), (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)p, (double)q, (double)q), GenericCableBakedModel.v((double)p, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)p, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)p, (double)q, (double)(1.0 - q)), spriteConnector, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)0.0, (double)q, (double)q), GenericCableBakedModel.v((double)0.0, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)0.0, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)0.0, (double)(1.0 - q), (double)q), spriteSide, hilight));
            } else {
                pattern = CablePatterns.findPattern(down, south, up, north);
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)o), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
            }
            if (north == ConnectorType.CABLE) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)0.0), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)0.0), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)0.0), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)0.0), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)0.0), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)0.0), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)0.0), GenericCableBakedModel.v((double)o, (double)o, (double)0.0), this.spriteCable, hilight));
            } else if (north == ConnectorType.BLOCK) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)p), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)p), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)p), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)p), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)p), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)p), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)p), GenericCableBakedModel.v((double)o, (double)o, (double)p), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)p), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)p), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)0.0), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)0.0), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)q, (double)0.0), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)0.0), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)p), GenericCableBakedModel.v((double)q, (double)q, (double)p), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)0.0), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)0.0), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)p), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)p), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)q, (double)p), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)p), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)0.0), GenericCableBakedModel.v((double)q, (double)q, (double)0.0), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)q, (double)p), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)p), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)p), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)p), spriteConnector, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)q, (double)0.0), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)0.0), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)0.0), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)0.0), spriteSide, hilight));
            } else {
                pattern = CablePatterns.findPattern(west, up, east, down);
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)o), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
            }
            if (south == ConnectorType.CABLE) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)1.0), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)1.0), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)1.0), GenericCableBakedModel.v((double)o, (double)o, (double)1.0), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)1.0), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)1.0), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)1.0), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)1.0), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
            } else if (south == ConnectorType.BLOCK) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - p)), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - p)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - p)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - p)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - p)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)1.0), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)1.0), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)(1.0 - p)), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)(1.0 - p)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)q, (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)1.0), GenericCableBakedModel.v((double)q, (double)q, (double)1.0), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)1.0), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)1.0), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)q, (double)1.0), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)1.0), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)(1.0 - p)), GenericCableBakedModel.v((double)q, (double)q, (double)(1.0 - p)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)(1.0 - p)), GenericCableBakedModel.v((double)q, (double)q, (double)(1.0 - p)), spriteConnector, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)1.0), GenericCableBakedModel.v((double)q, (double)q, (double)1.0), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)1.0), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)1.0), spriteSide, hilight));
            } else {
                pattern = CablePatterns.findPattern(west, down, east, up);
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
            }
        }
        if ((facadeId = (BlockState)extraData.get(GenericCableBlock.FACADEID)) != null) {
            BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(facadeId);
            ChunkRenderTypeSet renderTypes = model.getRenderTypes(facadeId, rand, extraData);
            if (layer == null || renderTypes.contains(layer)) {
                try {
                    quads.addAll(model.getQuads(state, side, rand, ModelData.EMPTY, layer));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @Nonnull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.all();
    }

    @Nonnull
    public TextureAtlasSprite getParticleIcon() {
        return this.spriteCable == null ? GenericCableBakedModel.getTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"missingno")) : this.spriteCable;
    }

    @Nonnull
    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }

    @Nonnull
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    static {
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, false, false, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_NONE, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, false, false, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_END, 3));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, true, false, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_END, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, false, true, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_END, 1));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, false, false, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_END, 2));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, true, false, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CORNER, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, true, true, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CORNER, 1));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, false, true, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CORNER, 2));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, false, false, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CORNER, 3));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, true, false, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_STRAIGHT, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, false, true, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_STRAIGHT, 1));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, true, true, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_THREE, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, true, true, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_THREE, 1));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, false, true, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_THREE, 2));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, true, false, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_THREE, 3));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, true, true, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CROSS, 0));
    }

    public static class CableTextures {
        private TextureAtlasSprite spriteConnector;
        private TextureAtlasSprite spriteAdvancedConnector;
        private TextureAtlasSprite spriteNoneCable;
        private TextureAtlasSprite spriteNormalCable;
        private TextureAtlasSprite spriteEndCable;
        private TextureAtlasSprite spriteCornerCable;
        private TextureAtlasSprite spriteThreeCable;
        private TextureAtlasSprite spriteCrossCable;
    }
}

