/*
 * Decompiled with CFR 0.152.
 */
package com.github.Pandarix.beautify.particle.custom;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class GlowEssenceParticles
extends TextureSheetParticle {
    private static final float size = 0.07f;

    protected GlowEssenceParticles(ClientLevel level, double xCoord, double yCoord, double zCoord, SpriteSet spriteSet, double xd, double yd, double zd) {
        super(level, xCoord, yCoord, zCoord, xd, yd, zd);
        this.friction = 0.8f;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.quadSize = 0.0f;
        this.lifetime = (int)(60.0 * (0.5 + Math.random() / 2.0));
        this.setSpriteFromAge(spriteSet);
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
    }

    private void fadeOut() {
        float fadeValue = (float)Math.sin(Math.PI * (double)((float)this.age / (float)this.lifetime));
        this.alpha = 1.0f * fadeValue;
        this.quadSize = 0.07f * fadeValue;
    }

    private void move() {
        if (Math.random() <= 0.05) {
            this.xd = (Math.random() * 2.0 - 1.0) / 70.0;
        }
        if (Math.random() <= 0.05) {
            this.yd = (Math.random() * 2.0 - 1.0) / 70.0;
        }
        if (Math.random() <= 0.05) {
            this.zd = (Math.random() * 2.0 - 1.0) / 70.0;
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public void tick() {
        super.tick();
        this.fadeOut();
        this.move();
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new GlowEssenceParticles(level, x, y, z, this.sprites, dx, dy, dz);
        }
    }
}

