/*
 * Decompiled with CFR 0.152.
 */
package com.github.Pandarix.beautify.common.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class Trellis
extends HorizontalDirectionalBlock {
    public static final MapCodec<Trellis> TRELLIS_MAP_CODEC = Trellis.simpleCodec(Trellis::new);
    private static final List<Item> VALID_FLOWERS = Arrays.asList(Items.AIR, Items.ROSE_BUSH, Items.SUNFLOWER, Items.PEONY, Items.LILAC, Items.VINE, Items.WEEPING_VINES, Items.TWISTING_VINES, Items.GLOW_LICHEN);
    public static final IntegerProperty FLOWERS = IntegerProperty.create((String)"flowers", (int)0, (int)(VALID_FLOWERS.size() - 1));
    public static final BooleanProperty CEILLING = BooleanProperty.create((String)"ceilling");
    private static final Map<Direction, VoxelShape> SHAPES_FOR_MODEL = ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (Object)Direction.WEST, (Object)Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0));
    private static final VoxelShape SHAPE_CEILLING = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public Trellis(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CEILLING, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return TRELLIS_MAP_CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace() == Direction.DOWN) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)CEILLING, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)CEILLING, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)CEILLING)).booleanValue()) {
            return SHAPE_CEILLING;
        }
        return SHAPES_FOR_MODEL.get(state.getValue((Property)FACING));
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return state.is((Block)this) || super.isLadder(state, level, pos, entity);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (interactionHand == InteractionHand.MAIN_HAND) {
            if ((Integer)blockState.getValue((Property)FLOWERS) != 0) {
                if (itemStack.isEmpty()) {
                    player.setItemInHand(interactionHand, new ItemStack((ItemLike)VALID_FLOWERS.get((Integer)blockState.getValue((Property)FLOWERS))));
                    level.setBlock(pos, (BlockState)blockState.setValue((Property)FLOWERS, (Comparable)Integer.valueOf(0)), 3);
                    level.playSound(null, pos, SoundEvents.AZALEA_LEAVES_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.SUCCESS;
                }
                if (itemStack.is(VALID_FLOWERS.get((Integer)blockState.getValue((Property)FLOWERS))) && itemStack.getCount() < itemStack.getMaxStackSize()) {
                    itemStack.grow(1);
                    level.setBlock(pos, (BlockState)blockState.setValue((Property)FLOWERS, (Comparable)Integer.valueOf(0)), 3);
                    level.playSound(null, pos, SoundEvents.AZALEA_LEAVES_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.FAIL;
            }
            for (Item flower : VALID_FLOWERS) {
                if (!itemStack.getItem().equals(flower)) continue;
                level.setBlock(pos, (BlockState)blockState.setValue((Property)FLOWERS, (Comparable)Integer.valueOf(VALID_FLOWERS.indexOf(flower))), 3);
                if (!flower.equals(Items.AIR)) {
                    level.playSound(null, pos, SoundEvents.AZALEA_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                itemStack.shrink(1);
                return ItemInteractionResult.CONSUME_PARTIAL;
            }
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57561_) {
        p_57561_.add(new Property[]{FACING, CEILLING, FLOWERS});
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (!Screen.hasShiftDown() && !Screen.hasControlDown()) {
            components.add((Component)Component.translatable((String)"tooltip.shift").withStyle(ChatFormatting.YELLOW));
            components.add((Component)Component.translatable((String)"tooltip.control").withStyle(ChatFormatting.YELLOW));
        }
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"trellis.description1").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"trellis.description2").withStyle(ChatFormatting.GRAY));
        }
        if (Screen.hasControlDown()) {
            components.add((Component)Component.translatable((String)"trellis.list1").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"trellis.list2").withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, components, flag);
    }
}

