/*
 * Decompiled with CFR 0.152.
 */
package com.github.Pandarix.beautify.common.block;

import com.github.Pandarix.beautify.particle.ParticleInit;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class LampJar
extends LanternBlock {
    private static final int maxLevel = 15;
    public static final IntegerProperty FILL_LEVEL = IntegerProperty.create((String)"fill_level", (int)0, (int)15);

    public LampJar(BlockBehaviour.Properties p_153465_) {
        super(p_153465_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pResult) {
        if (pHand == InteractionHand.MAIN_HAND) {
            int increase = 5;
            int currentLevel = (Integer)pState.getValue((Property)FILL_LEVEL);
            if (stack.isEmpty() && currentLevel > 0) {
                pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)Items.GLOWSTONE_DUST, currentLevel / 5));
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0)), 3);
                pLevel.playSound((Player)null, pPos, SoundEvents.AMETHYST_CLUSTER_BREAK, SoundSource.BLOCKS, 0.5f, 0.5f);
                return ItemInteractionResult.SUCCESS;
            }
            int newLevel = currentLevel + 5;
            if (stack.is(Items.GLOWSTONE_DUST) && newLevel <= 15) {
                stack.shrink(1);
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(newLevel)), 3);
                pLevel.playSound((Player)null, pPos, SoundEvents.AMETHYST_BLOCK_HIT, SoundSource.BLOCKS, 0.5f, (float)newLevel / 5.0f);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FILL_LEVEL});
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource rand) {
        if ((Integer)pState.getValue((Property)FILL_LEVEL) > 0 && rand.nextIntBetweenInclusive(0, 50) == 0) {
            pLevel.playLocalSound(pPos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 0.3f, 0.1f, true);
        }
        if (pLevel.isClientSide()) {
            int particleProbability = 5;
            double posX = (double)pPos.getX() + 0.35 + rand.nextDouble() / 3.5;
            double posY = (double)pPos.getY() + 0.1 + rand.nextDouble() / 3.5;
            double posZ = (double)pPos.getZ() + 0.35 + rand.nextDouble() / 3.5;
            if ((Integer)pState.getValue((Property)FILL_LEVEL) >= 5 && (Integer)pState.getValue((Property)FILL_LEVEL) < 10) {
                if (rand.nextInt(5) == 0) {
                    pLevel.addParticle((ParticleOptions)ParticleInit.GLOWESSENCE_PARTICLES.get(), posX, posY, posZ, LampJar.randomDir(rand), 0.01, LampJar.randomDir(rand));
                }
            } else if ((Integer)pState.getValue((Property)FILL_LEVEL) >= 10 && (Integer)pState.getValue((Property)FILL_LEVEL) < 15) {
                if (rand.nextInt(5) == 0) {
                    pLevel.addParticle((ParticleOptions)ParticleInit.GLOWESSENCE_PARTICLES.get(), posX, posY, posZ, LampJar.randomDir(rand), 0.01, LampJar.randomDir(rand));
                }
            } else if ((Integer)pState.getValue((Property)FILL_LEVEL) == 15) {
                posX = (double)pPos.getX() + 0.35 + rand.nextDouble() / 3.5;
                posY = (double)pPos.getY() + 0.1 + rand.nextDouble() / 3.5;
                posZ = (double)pPos.getZ() + 0.35 + rand.nextDouble() / 3.5;
                pLevel.addParticle((ParticleOptions)ParticleInit.GLOWESSENCE_PARTICLES.get(), posX, posY, posZ, LampJar.randomDir(rand), 0.01, LampJar.randomDir(rand));
            }
        }
    }

    private static double randomDir(RandomSource rand) {
        return (float)(rand.nextIntBetweenInclusive(0, 2) - 1) * rand.nextFloat() / 34.0f;
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (!Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.shift").withStyle(ChatFormatting.YELLOW));
        } else {
            components.add((Component)Component.translatable((String)"glowstone_essence_lamp.description1").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"glowstone_essence_lamp.description2").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"glowstone_essence_lamp.description3").withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, components, flag);
    }
}

