/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.JavaWrapper;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.rhino.type.TypeInfo;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

public record RegistryType<T>(ResourceKey<Registry<T>> key, Class<?> baseClass, TypeInfo type) {
    private static final Map<ResourceKey<?>, RegistryType<?>> KEY_MAP = new Reference2ObjectOpenHashMap();
    private static final Map<TypeInfo, RegistryType<?>> TYPE_MAP = new HashMap();
    private static final Map<Class<?>, List<RegistryType<?>>> CLASS_MAP = new Reference2ObjectOpenHashMap();

    public static synchronized <T> void register(ResourceKey<Registry<T>> key, TypeInfo type) {
        RegistryType<T> t = new RegistryType<T>(key, type.asClass(), type);
        KEY_MAP.put(key, t);
        TYPE_MAP.put(type, t);
        CLASS_MAP.computeIfAbsent(t.baseClass, c -> new ArrayList(1)).add(t);
        if (DevProperties.get().logRegistryTypes) {
            KubeJS.LOGGER.info("Registered RegistryType '{}': {}", (Object)key.location(), (Object)type);
        }
    }

    @Nullable
    public static synchronized <T> RegistryType<T> ofKey(ResourceKey<? extends Registry<T>> key) {
        Scanner.startIfNotFrozen();
        return (RegistryType)Cast.to(KEY_MAP.get(key));
    }

    @Nullable
    public static synchronized RegistryType<?> ofType(TypeInfo typeInfo) {
        Scanner.startIfNotFrozen();
        return TYPE_MAP.get(typeInfo);
    }

    @Nullable
    public static synchronized <T> RegistryType<T> ofClass(Class<T> type) {
        List<RegistryType<T>> regList = RegistryType.allOfClass(type);
        return regList != null && regList.size() == 1 ? regList.getFirst() : null;
    }

    public static synchronized <T> List<RegistryType<T>> allOfClass(Class<T> type) {
        Scanner.startIfNotFrozen();
        return (List)Cast.to(CLASS_MAP.getOrDefault(type, List.of()));
    }

    @Nullable
    public static synchronized RegistryType<?> lookup(TypeInfo target) {
        List reg = RegistryType.allOfClass(target.asClass());
        if (reg.size() == 1) {
            return reg.getFirst();
        }
        if (!reg.isEmpty()) {
            for (RegistryType regType : reg) {
                if (!regType.type().equals((Object)target)) continue;
                return regType;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.key.location()) + "=" + String.valueOf(this.type);
    }

    public static class Scanner {
        private static final Lazy<Set<Class<?>>> VALID_TYPES = Lazy.of(() -> {
            HashSet set = new HashSet();
            set.add(ResourceKey.class);
            set.add(Registry.class);
            Class<?> registrar = JavaWrapper.tryLoadClass("dev.architectury.registry.registries.Registrar");
            if (registrar != null) {
                set.add(registrar);
            }
            return set;
        });
        private static final Set<String> CLASSES_TO_SCAN = new HashSet<String>();
        private static final Set<String> MODULES_TO_SKIP = Set.of("java.base", "neoforge", "fml_loader", "kubejs");
        private static final Set<String> NAMESPACES_TO_SKIP = Set.of("neoforge", "minecraft");
        private static boolean frozen = false;

        public static synchronized void init() {
            Scanner.processClass(Stream.of(Registries.class, NeoForgeRegistries.Keys.class));
        }

        private static synchronized void startIfNotFrozen() {
            if (frozen) {
                return;
            }
            frozen = true;
            long startTime = Util.getNanos();
            Scanner.processClass(CLASSES_TO_SCAN.stream().map(JavaWrapper::tryLoadClass));
            CLASSES_TO_SCAN.clear();
            KubeJS.LOGGER.debug("Took {} ms to discover registry classes.", (Object)((int)((Util.getNanos() - startTime) / 1000000L)));
        }

        private static void processClass(Stream<Class<?>> classStream) {
            classStream.filter(Objects::nonNull).map(Class::getDeclaredFields).flatMap(Stream::of).forEach(field -> {
                try {
                    Type patt0$temp;
                    Object value;
                    if (!((Set)VALID_TYPES.get()).contains(field.getType()) || !Modifier.isStatic(field.getModifiers())) {
                        return;
                    }
                    if (!Modifier.isPublic(field.getModifiers())) {
                        field.setAccessible(true);
                    }
                    if ((value = field.get(null)) instanceof ResourceKey) {
                        ParameterizedType t1;
                        Type patt1$temp;
                        ResourceKey key = (ResourceKey)value;
                        Type patt0$temp2 = field.getGenericType();
                        if (patt0$temp2 instanceof ParameterizedType && (patt1$temp = (t1 = (ParameterizedType)patt0$temp2).getActualTypeArguments()[0]) instanceof ParameterizedType) {
                            ParameterizedType t2 = (ParameterizedType)patt1$temp;
                            Scanner.processKey(key, t2, false);
                        }
                    } else if (value instanceof Registry) {
                        Registry registry = (Registry)value;
                        Type patt0$temp3 = field.getGenericType();
                        if (patt0$temp3 instanceof ParameterizedType) {
                            ParameterizedType t1 = (ParameterizedType)patt0$temp3;
                            Scanner.processKey(registry.key(), t1, true);
                        }
                    } else if (field.getType().getName().equals("dev.architectury.registry.registries.Registrar") && (patt0$temp = field.getGenericType()) instanceof ParameterizedType) {
                        ParameterizedType t1 = (ParameterizedType)patt0$temp;
                        Method method = value.getClass().getDeclaredMethod("key", new Class[0]);
                        Scanner.processKey((ResourceKey)method.invoke(value, new Object[0]), t1, true);
                    }
                }
                catch (Exception ex) {
                    KubeJS.LOGGER.error("Error while trying to get registry from field {} from class {}", new Object[]{field.getName(), field.getType().getName(), ex});
                }
            });
        }

        private static void processKey(ResourceKey key, ParameterizedType paramType, boolean checkIfContains) {
            if (checkIfContains && RegistryType.ofKey(key) != null) {
                return;
            }
            Type type = paramType.getActualTypeArguments()[0];
            TypeInfo typeInfo = TypeInfo.of((Type)type);
            RegistryType.register(key, typeInfo);
        }

        public static synchronized void scan(ResourceLocation registryName, ResourceLocation location) {
            StackTraceElement[] stack;
            if (frozen) {
                return;
            }
            if (!registryName.equals((Object)Registries.ROOT_REGISTRY_NAME)) {
                return;
            }
            if (NAMESPACES_TO_SKIP.contains(location.getNamespace())) {
                return;
            }
            long startTime = Util.getNanos();
            for (StackTraceElement stackTraceElement : stack = Thread.currentThread().getStackTrace()) {
                String className;
                String moduleName = stackTraceElement.getModuleName();
                if (moduleName != null && MODULES_TO_SKIP.contains(moduleName) || CLASSES_TO_SCAN.contains(className = stackTraceElement.getClassName())) continue;
                CLASSES_TO_SCAN.add(className);
            }
            KubeJS.LOGGER.debug("Took {} ms to grab stacktrace classes.", (Object)((int)((Util.getNanos() - startTime) / 1000000L)));
        }
    }
}

