/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import dev.latvian.mods.kubejs.DevProperties;
import java.net.URI;
import java.nio.file.Path;
import net.minecraft.Util;

public class EditorExt {
    public static final String VSCODE = EditorExt.vsLikeScheme("vscode");
    public static final String VSCODIUM = EditorExt.vsLikeScheme("vscodium");
    public static final String VSCODE_OSS = EditorExt.vsLikeScheme("vscode-oss");

    private static String vsLikeScheme(String prefix) {
        return prefix + "://file{path}:{line}:{col}";
    }

    public static boolean isKnownVSCode() {
        String custom = DevProperties.get().openUriFormat;
        return !custom.isEmpty() && (custom.equals(VSCODE) || custom.equals(VSCODIUM) || custom.equals(VSCODE_OSS));
    }

    private static URI format(String scheme, Path path, int line, int column) {
        return URI.create(scheme.replace("{path}", path.toString()).replace("{line}", String.valueOf(line)).replace("{col}", String.valueOf(column)));
    }

    public static void openFile(Path path, int line, int column) {
        String custom = DevProperties.get().openUriFormat;
        if (!custom.isBlank()) {
            Util.getPlatform().openUri(EditorExt.format(custom, path, line, column));
        } else {
            Util.getPlatform().openPath(path);
        }
    }
}

