/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.tools.rules.IEventQuery;
import mcjty.incontrol.tools.rules.TestingTools;
import mcjty.incontrol.tools.varia.LookAtTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class TestingBlockTools {
    private static boolean testBlockStateSafe(LevelAccessor world, BlockPos pos, Block block) {
        LevelChunk chunk = world.getChunkSource().getChunkNow(pos.getX() >> 4, pos.getZ() >> 4);
        if (chunk != null) {
            BlockState state = world.getBlockState(pos);
            return state.getBlock() == block;
        }
        return false;
    }

    private static boolean testBlockStateSafe(LevelAccessor world, BlockPos pos, BlockState block) {
        LevelChunk chunk = world.getChunkSource().getChunkNow(pos.getX() >> 4, pos.getZ() >> 4);
        if (chunk != null) {
            BlockState state = world.getBlockState(pos);
            return state == block;
        }
        return false;
    }

    @Nullable
    public static BlockMatcherWithSettings parseBlockWithSettings(String json) {
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        BiPredicate<LevelAccessor, BlockPos> matcher = TestingBlockTools.parseBlockJson(element);
        if (matcher == null) {
            return null;
        }
        int distbelow = 1;
        int distabove = 0;
        boolean onlyAir = false;
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("distbelow")) {
                distbelow = obj.get("distbelow").getAsInt();
            }
            if (obj.has("distabove")) {
                distabove = obj.get("distabove").getAsInt();
            }
            if (obj.has("onlyair")) {
                onlyAir = obj.get("onlyair").getAsBoolean();
            }
        }
        return new BlockMatcherWithSettings(matcher, distbelow, distabove, onlyAir);
    }

    @Nullable
    public static BiPredicate<LevelAccessor, BlockPos> parseBlock(String json) {
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        return TestingBlockTools.parseBlockJson(element);
    }

    @Nullable
    public static BiPredicate<LevelAccessor, BlockPos> parseBlockJson(JsonElement element) {
        if (element.isJsonPrimitive()) {
            String blockname = element.getAsString();
            if (blockname.startsWith("tag:")) {
                ResourceLocation tagname = ResourceLocation.parse((String)blockname.substring(4));
                TagKey key = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tagname);
                return (world, pos) -> {
                    BlockState state = world.getBlockState(pos);
                    return state.is(key);
                };
            }
            if (!BuiltInRegistries.BLOCK.containsKey(ResourceLocation.parse((String)blockname))) {
                ErrorHandler.error("Block '" + blockname + "' is not valid!");
                return null;
            }
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockname));
            return (world, pos) -> TestingBlockTools.testBlockStateSafe(world, pos, block);
        }
        if (element.isJsonObject()) {
            BiPredicate<LevelAccessor, BlockPos> finalTest;
            Predicate<Integer> energy;
            BiPredicate<LevelAccessor, BlockPos> test;
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("tag")) {
                ResourceLocation tagname = ResourceLocation.parse((String)obj.get("tag").getAsString());
                TagKey key = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tagname);
                test = (world, pos) -> {
                    BlockState state = world.getBlockState(pos);
                    return state.is(key);
                };
            } else if (obj.has("block")) {
                String blockname = obj.get("block").getAsString();
                if (!BuiltInRegistries.BLOCK.containsKey(ResourceLocation.parse((String)blockname))) {
                    ErrorHandler.error("Block '" + blockname + "' is not valid!");
                    return null;
                }
                Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockname));
                if (obj.has("properties")) {
                    BlockState blockState = block.defaultBlockState();
                    JsonArray propArray = obj.get("properties").getAsJsonArray();
                    for (JsonElement el : propArray) {
                        JsonObject propObj = el.getAsJsonObject();
                        String name = propObj.get("name").getAsString();
                        String value = propObj.get("value").getAsString();
                        for (Property key : blockState.getProperties()) {
                            if (!name.equals(key.getName())) continue;
                            blockState = TestingTools.set(blockState, key, value);
                        }
                    }
                    BlockState finalBlockState = blockState;
                    test = (world, pos) -> TestingBlockTools.testBlockStateSafe(world, pos, finalBlockState);
                } else {
                    test = (world, pos) -> TestingBlockTools.testBlockStateSafe(world, pos, block);
                }
            } else {
                test = (world, pos) -> true;
            }
            if (obj.has("mod")) {
                String mod = obj.get("mod").getAsString();
                BiPredicate<LevelAccessor, BlockPos> finalTest2 = test;
                test = (world, pos) -> {
                    LevelChunk chunk = world.getChunkSource().getChunkNow(pos.getX() >> 4, pos.getZ() >> 4);
                    if (chunk != null) {
                        return finalTest2.test((LevelAccessor)world, (BlockPos)pos) && mod.equals(BuiltInRegistries.BLOCK.getKey((Object)world.getBlockState(pos).getBlock()).getNamespace());
                    }
                    return false;
                };
            }
            if (obj.has("energy") && (energy = TestingTools.getExpression(obj.get("energy"))) != null) {
                Direction side = obj.has("side") ? Direction.byName((String)obj.get("side").getAsString().toLowerCase()) : null;
                finalTest = test;
                test = (world, pos) -> finalTest.test((LevelAccessor)world, (BlockPos)pos) && energy.test(TestingTools.getEnergy(world, pos, side));
            }
            if (obj.has("contains")) {
                Direction side = obj.has("side") ? Direction.byName((String)obj.get("energyside").getAsString().toLowerCase()) : null;
                List<Predicate<ItemStack>> items = TestingTools.getItemsJson(obj.get("contains"));
                finalTest = test;
                test = (world, pos) -> finalTest.test((LevelAccessor)world, (BlockPos)pos) && TestingTools.contains(world, pos, side, items);
            }
            return test;
        }
        ErrorHandler.error("Block description is not valid!");
        return null;
    }

    @Nonnull
    public static BiFunction<Object, IEventQuery, BlockPos> parseOffset(String json) {
        int offsetZ;
        int offsetY;
        int offsetX;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("offset")) {
            JsonObject offset = obj.getAsJsonObject("offset");
            offsetX = offset.has("x") ? offset.get("x").getAsInt() : 0;
            offsetY = offset.has("y") ? offset.get("y").getAsInt() : 0;
            offsetZ = offset.has("z") ? offset.get("z").getAsInt() : 0;
        } else {
            offsetX = obj.has("x") ? obj.get("x").getAsInt() : 0;
            offsetY = obj.has("y") ? obj.get("y").getAsInt() : 0;
            int n = offsetZ = obj.has("z") ? obj.get("z").getAsInt() : 0;
        }
        if (obj.has("look")) {
            return (event, query) -> {
                HitResult result = LookAtTools.getMovingObjectPositionFromPlayer(query.getWorld(event), query.getPlayer(event), false);
                if (result instanceof BlockHitResult) {
                    return ((BlockHitResult)result).getBlockPos().offset(offsetX, offsetY, offsetZ);
                }
                return query.getValidBlockPos(event).offset(offsetX, offsetY, offsetZ);
            };
        }
        return (event, query) -> query.getValidBlockPos(event).offset(offsetX, offsetY, offsetZ);
    }

    public record BlockMatcherWithSettings(BiPredicate<LevelAccessor, BlockPos> matcher, int distBelow, int distAbove, boolean onlyAir) {
    }
}

