/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs;

import guideme.internal.shaded.lucene.codecs.NormsProducer;
import guideme.internal.shaded.lucene.index.DocIDMerger;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.MergeState;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;

public abstract class NormsConsumer
implements Closeable {
    protected NormsConsumer() {
    }

    public abstract void addNormsField(FieldInfo var1, NormsProducer var2) throws IOException;

    public void merge(MergeState mergeState) throws IOException {
        for (NormsProducer normsProducer : mergeState.normsProducers) {
            if (normsProducer == null) continue;
            normsProducer.checkIntegrity();
        }
        for (FieldInfo mergeFieldInfo : mergeState.mergeFieldInfos) {
            if (!mergeFieldInfo.hasNorms()) continue;
            this.mergeNormsField(mergeFieldInfo, mergeState);
        }
    }

    public void mergeNormsField(final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        this.addNormsField(mergeFieldInfo, new NormsProducer(this){

            @Override
            public NumericDocValues getNorms(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                ArrayList<NumericDocValuesSub> subs = new ArrayList<NumericDocValuesSub>();
                assert (mergeState.docMaps.length == mergeState.docValuesProducers.length);
                for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    FieldInfo readerFieldInfo;
                    NumericDocValues norms = null;
                    NormsProducer normsProducer = mergeState.normsProducers[i];
                    if (normsProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && readerFieldInfo.hasNorms()) {
                        norms = normsProducer.getNorms(readerFieldInfo);
                    }
                    if (norms == null) continue;
                    subs.add(new NumericDocValuesSub(mergeState.docMaps[i], norms));
                }
                final DocIDMerger docIDMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
                return new NumericDocValues(this){
                    private int docID = -1;
                    private NumericDocValuesSub current;

                    @Override
                    public int docID() {
                        return this.docID;
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        this.current = (NumericDocValuesSub)docIDMerger.next();
                        this.docID = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
                        return this.docID;
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public long cost() {
                        return 0L;
                    }

                    @Override
                    public long longValue() throws IOException {
                        return this.current.values.longValue();
                    }
                };
            }

            @Override
            public void checkIntegrity() {
            }

            @Override
            public void close() {
            }
        });
    }

    private static class NumericDocValuesSub
    extends DocIDMerger.Sub {
        private final NumericDocValues values;

        public NumericDocValuesSub(MergeState.DocMap docMap, NumericDocValues values) {
            super(docMap);
            this.values = values;
            assert (values.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }
}

