/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import java.util.List;
import java.util.function.Supplier;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.compiled.CompiledVacuumModule;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class VacuumModule
extends ModuleItem
implements IRangedModule {
    private static final TintColor TINT_COLOR = new TintColor(120, 48, 191);

    public VacuumModule() {
        super(ModItems.moduleProps().component(ModDataComponents.VACUUM_SETTINGS.get(), (Object)CompiledVacuumModule.VacuumSettings.DEFAULT), CompiledVacuumModule::new);
    }

    @Override
    public MenuType<? extends ModuleMenu> getMenuType() {
        return ModMenuTypes.VACUUM_MENU.get();
    }

    @Override
    public void addSettingsInformation(ItemStack stack, List<Component> list) {
        boolean xpMode;
        super.addSettingsInformation(stack, list);
        boolean bl = xpMode = new AugmentItem.AugmentCounter(stack).getAugmentCount((Supplier<Item>)ModItems.XP_VACUUM_AUGMENT) > 0;
        if (xpMode) {
            CompiledVacuumModule.VacuumSettings settings = (CompiledVacuumModule.VacuumSettings)stack.getOrDefault(ModDataComponents.VACUUM_SETTINGS, (Object)CompiledVacuumModule.VacuumSettings.DEFAULT);
            XPCollection.XPCollectionType type = settings.collectionType();
            MutableComponent modName = Component.literal((String)ModNameCache.getModName(type.getModId())).withStyle(ChatFormatting.BLUE);
            MutableComponent title = type.getDisplayName().plainCopy().withStyle(ChatFormatting.AQUA);
            list.add((Component)ClientUtil.xlate("modularrouters.guiText.label.xpVacuum", new Object[0]).append(": ").withStyle(ChatFormatting.YELLOW).append((Component)title).append(" - ").append((Component)modName));
            if (settings.autoEject() && !type.isSolid()) {
                list.add(MiscUtil.settingsStr(ChatFormatting.GREEN.toString(), (Component)ClientUtil.xlate("modularrouters.guiText.tooltip.xpVacuum.ejectFluid", new Object[0])));
            }
        }
    }

    @Override
    public int getBaseRange() {
        return (Integer)ConfigHolder.common.module.vacuumBaseRange.get();
    }

    @Override
    public int getHardMaxRange() {
        return (Integer)ConfigHolder.common.module.vacuumMaxRange.get();
    }

    @Override
    public boolean isOmniDirectional() {
        return true;
    }

    @Override
    public TintColor getItemTint() {
        return TINT_COLOR;
    }

    @Override
    public int getEnergyCost(ItemStack stack) {
        return (Integer)ConfigHolder.common.energyCosts.vacuumModuleEnergyCost.get();
    }
}

