/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WroughtIronShortGateBlock
extends FenceGateBlock {
    private static final VoxelShape NORTH_CLOSED = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)20.0, (double)1.0);
    private static final VoxelShape SOUTH_CLOSED = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)20.0, (double)16.0);
    private static final VoxelShape WEST_CLOSED = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)20.0, (double)16.0);
    private static final VoxelShape EAST_CLOSED = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)20.0, (double)16.0);
    private static final VoxelShape NORTH_OPEN = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)20.0, (double)8.0), (VoxelShape)Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)20.0, (double)8.0));
    private static final VoxelShape SOUTH_OPEN = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)8.0, (double)1.0, (double)20.0, (double)16.0), (VoxelShape)Block.box((double)15.0, (double)0.0, (double)8.0, (double)16.0, (double)20.0, (double)16.0));
    private static final VoxelShape WEST_OPEN = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)20.0, (double)1.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)15.0, (double)8.0, (double)20.0, (double)16.0));
    private static final VoxelShape EAST_OPEN = Shapes.or((VoxelShape)Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)20.0, (double)1.0), (VoxelShape)Block.box((double)8.0, (double)0.0, (double)15.0, (double)16.0, (double)20.0, (double)16.0));

    public WroughtIronShortGateBlock(BlockBehaviour.Properties properties) {
        super(WoodType.OAK, properties);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            return WroughtIronShortGateBlock.getOpenShapeForFacing(facing);
        }
        return WroughtIronShortGateBlock.getClosedShapeForFacing(facing);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            return WroughtIronShortGateBlock.getOpenShapeForFacing(facing);
        }
        return WroughtIronShortGateBlock.getClosedShapeForFacing(facing);
    }

    private static VoxelShape getClosedShapeForFacing(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> NORTH_CLOSED;
            case Direction.SOUTH -> SOUTH_CLOSED;
            case Direction.WEST -> WEST_CLOSED;
            case Direction.EAST -> EAST_CLOSED;
            default -> NORTH_CLOSED;
        };
    }

    private static VoxelShape getOpenShapeForFacing(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> NORTH_OPEN;
            case Direction.SOUTH -> SOUTH_OPEN;
            case Direction.WEST -> WEST_OPEN;
            case Direction.EAST -> EAST_OPEN;
            default -> NORTH_OPEN;
        };
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        boolean wasOpen = (Boolean)state.getValue((Property)OPEN);
        boolean willOpen = !wasOpen;
        BlockState newState = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(willOpen));
        level.setBlock(pos, newState, 3);
        level.playSound(null, pos, willOpen ? SoundEvents.ANVIL_HIT : SoundEvents.ANVIL_PLACE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
        level.gameEvent((Entity)player, (Holder)(willOpen ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        return InteractionResult.CONSUME;
    }
}

