/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WroughtIronGateBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public WroughtIronGateBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)Part.LOWER))).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)OPEN, (Comparable)Boolean.FALSE)).setValue((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, HINGE, OPEN, POWERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        Level level = ctx.getLevel();
        if (!(level.getBlockState(pos).canBeReplaced(ctx) && level.getBlockState(pos.above()).canBeReplaced(ctx) && level.getBlockState(pos.above(2)).canBeReplaced(ctx))) {
            return null;
        }
        Direction facing = ctx.getHorizontalDirection();
        Vec3 hit = ctx.getClickLocation();
        double hitX = hit.x - (double)pos.getX();
        double hitZ = hit.z - (double)pos.getZ();
        DoorHingeSide hinge = DoorHingeSide.LEFT;
        switch (facing) {
            case NORTH: {
                hinge = hitX > 0.5 ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
                break;
            }
            case SOUTH: {
                hinge = hitX < 0.5 ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
                break;
            }
            case WEST: {
                hinge = hitZ < 0.5 ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
                break;
            }
            case EAST: {
                hinge = hitZ > 0.5 ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(PART, (Comparable)((Object)Part.LOWER))).setValue(HINGE, (Comparable)hinge)).setValue((Property)OPEN, (Comparable)Boolean.FALSE)).setValue((Property)POWERED, (Comparable)Boolean.FALSE);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (level.isClientSide) {
            return;
        }
        BlockState middle = (BlockState)state.setValue(PART, (Comparable)((Object)Part.MIDDLE));
        BlockState upper = (BlockState)state.setValue(PART, (Comparable)((Object)Part.UPPER));
        level.setBlock(pos.above(), middle, 3);
        level.setBlock(pos.above(2), upper, 3);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            Part part = (Part)((Object)state.getValue(PART));
            BlockPos basePos = this.getBasePos(pos, part);
            for (int i = 0; i < 3; ++i) {
                BlockState s;
                BlockPos p = basePos.above(i);
                if (p.equals((Object)pos) || (s = level.getBlockState(p)).getBlock() != this) continue;
                level.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    private BlockPos getBasePos(BlockPos pos, Part part) {
        return switch (part.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> pos;
            case 1 -> pos.below();
            case 2 -> pos.below(2);
        };
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        boolean open = (Boolean)state.getValue((Property)OPEN) == false;
        this.setOpen(level, pos, state, open);
        this.toggleNeighborDoor(level, pos, state, open);
        return InteractionResult.CONSUME;
    }

    private void setOpen(Level level, BlockPos pos, BlockState state, boolean open) {
        BlockPos basePos = this.getBasePos(pos, (Part)((Object)state.getValue(PART)));
        for (int i = 0; i < 3; ++i) {
            BlockPos p = basePos.above(i);
            BlockState s = level.getBlockState(p);
            if (s.getBlock() != this) continue;
            level.setBlock(p, (BlockState)s.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
        this.playOpenCloseSound(level, basePos, open);
    }

    private void toggleNeighborDoor(Level level, BlockPos pos, BlockState state, boolean open) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean hingeRight = state.getValue(HINGE) == DoorHingeSide.RIGHT;
        Direction side = hingeRight ? facing.getCounterClockWise() : facing.getClockWise();
        BlockPos basePos = this.getBasePos(pos, (Part)((Object)state.getValue(PART)));
        BlockPos neighborBase = basePos.relative(side);
        BlockState neighborState = level.getBlockState(neighborBase);
        if (neighborState.getBlock() != this) {
            return;
        }
        if (neighborState.getValue((Property)FACING) != facing) {
            return;
        }
        if (neighborState.getValue(HINGE) == state.getValue(HINGE)) {
            return;
        }
        this.setOpen(level, neighborBase, neighborState, open);
    }

    private void playOpenCloseSound(Level level, BlockPos pos, boolean open) {
        level.playSound(null, pos, open ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean currentlyPowered;
        if (level.isClientSide) {
            return;
        }
        Part part = (Part)((Object)state.getValue(PART));
        BlockPos basePos = this.getBasePos(pos, part);
        if (!pos.equals((Object)basePos)) {
            return;
        }
        boolean powered = level.hasNeighborSignal(basePos) || level.hasNeighborSignal(basePos.above()) || level.hasNeighborSignal(basePos.above(2));
        if (powered != (currentlyPowered = ((Boolean)state.getValue((Property)POWERED)).booleanValue())) {
            for (int i = 0; i < 3; ++i) {
                BlockPos p = basePos.above(i);
                BlockState s = level.getBlockState(p);
                if (s.getBlock() != this) continue;
                level.setBlock(p, (BlockState)s.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
            }
            this.setOpen(level, basePos, state, powered);
        }
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean hingeRight;
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean open = (Boolean)state.getValue((Property)OPEN);
        boolean bl = hingeRight = state.getValue(HINGE) == DoorHingeSide.RIGHT;
        if (!open) {
            return switch (facing) {
                case Direction.NORTH -> NORTH_SHAPE;
                case Direction.SOUTH -> SOUTH_SHAPE;
                case Direction.WEST -> WEST_SHAPE;
                case Direction.EAST -> EAST_SHAPE;
                default -> Shapes.block();
            };
        }
        return switch (facing) {
            case Direction.NORTH -> {
                if (hingeRight) {
                    yield EAST_SHAPE;
                }
                yield WEST_SHAPE;
            }
            case Direction.SOUTH -> {
                if (hingeRight) {
                    yield WEST_SHAPE;
                }
                yield EAST_SHAPE;
            }
            case Direction.WEST -> {
                if (hingeRight) {
                    yield NORTH_SHAPE;
                }
                yield SOUTH_SHAPE;
            }
            case Direction.EAST -> {
                if (hingeRight) {
                    yield SOUTH_SHAPE;
                }
                yield NORTH_SHAPE;
            }
            default -> Shapes.block();
        };
    }

    public static enum Part implements StringRepresentable
    {
        LOWER,
        MIDDLE,
        UPPER;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

