/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class WallsVertLayer
extends Block
implements SimpleWaterloggedBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final IntegerProperty LAYERS = IntegerProperty.create((String)"layers", (int)1, (int)8);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final String NBT_LAYERS = "layers";
    private final Supplier<Block> fullBlock;

    public WallsVertLayer(BlockBehaviour.Properties properties, Supplier<Block> fullBlock) {
        super(properties);
        this.fullBlock = Objects.requireNonNull(fullBlock, "fullBlock supplier is null");
        Block fb = this.fullBlock.get();
        if (fb == null) {
            throw new IllegalArgumentException("fullBlock supplier returned null");
        }
        if (fb == this) {
            throw new IllegalArgumentException("fullBlock must not be the same block");
        }
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)fb);
        if (id == null || id.getPath().isEmpty()) {
            throw new IllegalStateException("fullBlock is not registered");
        }
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1))).setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LAYERS, FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState here = level.getBlockState(pos);
        @Nullable Player player = ctx.getPlayer();
        ItemStack held = ctx.getItemInHand();
        boolean hasLayers = WallsVertLayer.stackHasLayers(held);
        if (here.is((Block)this) && player != null && !player.isShiftKeyDown() && here.hasProperty((Property)LAYERS) && (Integer)here.getValue((Property)LAYERS) < 8 && !hasLayers) {
            int cur = (Integer)here.getValue((Property)LAYERS);
            if (cur == 7) {
                BlockState full = this.safeFullFrom(here);
                if (full != null) {
                    return full;
                }
                LOGGER.warn("Skipping full-block swap for {} at {} during placement: bad mapping; using layer 8 fallback", (Object)this, (Object)pos);
                return (BlockState)((BlockState)here.setValue((Property)LAYERS, (Comparable)Integer.valueOf(8))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE);
            }
            return (BlockState)((BlockState)here.setValue((Property)LAYERS, (Comparable)Integer.valueOf(cur + 1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE);
        }
        int layers = WallsVertLayer.layersFromStack(held, 1);
        boolean water = level.getFluidState(pos).getType() == Fluids.WATER;
        Direction facing = ctx.getHorizontalDirection();
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf(layers))).setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext ctx) {
        ItemStack held = ctx.getItemInHand();
        boolean hasLayers = WallsVertLayer.stackHasLayers(held);
        Player player = ctx.getPlayer();
        if (!held.isEmpty() && held.is(this.asItem()) && state.hasProperty((Property)LAYERS) && (Integer)state.getValue((Property)LAYERS) < 8 && player != null && !player.isShiftKeyDown() && !hasLayers) {
            return true;
        }
        return super.canBeReplaced(state, ctx);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!stack.is(this.asItem())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int cur = (Integer)state.getValue((Property)LAYERS);
        if (cur >= 8) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            if (cur == 7) {
                BlockState full = this.safeFullFrom(state);
                if (full != null) {
                    level.setBlock(pos, full, 3);
                } else {
                    LOGGER.warn("Skipping full-block swap for {} at {} on use: bad mapping; using layer 8 fallback", (Object)this, (Object)pos);
                    level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(8))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE), 3);
                }
            } else {
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(cur + 1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE), 3);
            }
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            if (player != null && !player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos fromPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, dir, neighbor, level, pos, fromPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return WallsVertLayer.shapeFor(state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return WallsVertLayer.shapeFor(state);
    }

    private static VoxelShape shapeFor(BlockState state) {
        int size = Math.min(16, (Integer)state.getValue((Property)LAYERS) * 2);
        boolean y0 = false;
        int y1 = 16;
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> Block.box((double)0.0, (double)((double)y0), (double)0.0, (double)16.0, (double)y1, (double)size);
            case Direction.SOUTH -> Block.box((double)0.0, (double)((double)y0), (double)(16 - size), (double)16.0, (double)y1, (double)16.0);
            case Direction.WEST -> Block.box((double)0.0, (double)((double)y0), (double)0.0, (double)size, (double)y1, (double)16.0);
            case Direction.EAST -> Block.box((double)(16 - size), (double)((double)y0), (double)0.0, (double)16.0, (double)y1, (double)16.0);
            default -> Block.box((double)0.0, (double)((double)y0), (double)(16 - size), (double)16.0, (double)y1, (double)16.0);
        };
    }

    private static int layersFromStack(@Nullable ItemStack stack, int def) {
        if (stack == null || stack.isEmpty()) {
            return def;
        }
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag nbt = data.copyTag();
        if (!nbt.contains(NBT_LAYERS)) {
            return def;
        }
        int v = nbt.getInt(NBT_LAYERS);
        return Mth.clamp((int)v, (int)1, (int)8);
    }

    private static boolean stackHasLayers(@Nullable ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag nbt = data.copyTag();
        return nbt.contains(NBT_LAYERS);
    }

    private BlockState safeFullFrom(BlockState src) {
        Block fb;
        try {
            fb = this.fullBlock.get();
        }
        catch (Exception e) {
            LOGGER.warn("fullBlock supplier threw", (Throwable)e);
            return null;
        }
        if (fb == null || fb == this) {
            return null;
        }
        BlockState full = fb.defaultBlockState();
        if (full.hasProperty((Property)WATERLOGGED) && src.hasProperty((Property)WATERLOGGED)) {
            full = (BlockState)full.setValue((Property)WATERLOGGED, (Comparable)((Boolean)src.getValue((Property)WATERLOGGED)));
        }
        return full;
    }
}

