/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class VerticalPillarBlock
extends Block {
    public static final EnumProperty<PillarPart> SECTION = EnumProperty.create((String)"section", PillarPart.class);

    public VerticalPillarBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(SECTION, (Comparable)((Object)PillarPart.BOTTOM)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SECTION});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return this.updateBlockState(level, pos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean movedByPiston) {
        level.setBlock(pos, this.updateBlockState(level, pos), 3);
        super.neighborChanged(state, level, pos, block, neighborPos, movedByPiston);
    }

    private BlockState updateBlockState(Level level, BlockPos pos) {
        boolean hasPillarAbove;
        BlockState belowState = level.getBlockState(pos.below());
        BlockState aboveState = level.getBlockState(pos.above());
        boolean hasPillarBelow = belowState.getBlock() == this;
        boolean bl = hasPillarAbove = aboveState.getBlock() == this;
        if (hasPillarBelow && hasPillarAbove) {
            return (BlockState)this.defaultBlockState().setValue(SECTION, (Comparable)((Object)PillarPart.MIDDLE));
        }
        if (hasPillarBelow) {
            return (BlockState)this.defaultBlockState().setValue(SECTION, (Comparable)((Object)PillarPart.TOP));
        }
        if (hasPillarAbove) {
            return (BlockState)this.defaultBlockState().setValue(SECTION, (Comparable)((Object)PillarPart.BOTTOM));
        }
        return (BlockState)this.defaultBlockState().setValue(SECTION, (Comparable)((Object)PillarPart.BOTTOM));
    }

    public static enum PillarPart implements StringRepresentable
    {
        BOTTOM,
        MIDDLE,
        TOP;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

