/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VertQtrLayers
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty LAYERS = IntegerProperty.create((String)"layers", (int)1, (int)8);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final String NBT_LAYERS = "layers";

    public VertQtrLayers(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1))).setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LAYERS, FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState here = level.getBlockState(pos);
        Player player = ctx.getPlayer();
        ItemStack held = ctx.getItemInHand();
        boolean hasLayers = VertQtrLayers.stackHasLayers(held);
        if (!(!here.is((Block)this) || player != null && player.isShiftKeyDown() || (Integer)here.getValue((Property)LAYERS) >= 8 || hasLayers)) {
            return (BlockState)here.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, (Integer)here.getValue((Property)LAYERS) + 1)));
        }
        boolean water = level.getFluidState(pos).getType() == Fluids.WATER;
        int layers = VertQtrLayers.layersFromStack(held, 1);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)LAYERS, (Comparable)Integer.valueOf(layers))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext ctx) {
        BlockItem bi;
        ItemStack held = ctx.getItemInHand();
        boolean hasLayers = VertQtrLayers.stackHasLayers(held);
        Item item = held.getItem();
        if (item instanceof BlockItem && (bi = (BlockItem)item).getBlock() == this && (Integer)state.getValue((Property)LAYERS) < 8 && !hasLayers) {
            return true;
        }
        return super.canBeReplaced(state, ctx);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockItem bi;
        Item item = stack.getItem();
        if (!(item instanceof BlockItem) || (bi = (BlockItem)item).getBlock() != this) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if ((Integer)state.getValue((Property)LAYERS) >= 8) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf((Integer)state.getValue((Property)LAYERS) + 1)), 3);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeFor(state);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeFor(state);
    }

    protected VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.shapeFor(state);
    }

    private VoxelShape shapeFor(BlockState state) {
        int z0;
        int x1;
        int x0;
        int size = Math.min(16, (Integer)state.getValue((Property)LAYERS) * 2);
        boolean y0 = false;
        int y1 = 16;
        return Block.box((double)x0, (double)((double)y0), (double)z0, (double)x1, (double)y1, (double)(switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> {
                x0 = 16 - size;
                x1 = 16;
                z0 = 16 - size;
                yield 16;
            }
            case Direction.EAST -> {
                x0 = 16 - size;
                x1 = 16;
                z0 = 0;
                yield size;
            }
            case Direction.NORTH -> {
                x0 = 0;
                x1 = size;
                z0 = 0;
                yield size;
            }
            case Direction.WEST -> {
                x0 = 0;
                x1 = size;
                z0 = 16 - size;
                yield 16;
            }
            default -> {
                x0 = 16 - size;
                x1 = 16;
                z0 = 16 - size;
                yield 16;
            }
        }));
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.getValue((Property)LAYERS) >= 8 ? Shapes.block() : Shapes.empty();
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.getValue((Property)LAYERS) < 8;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    private static boolean stackHasLayers(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = data.copyTag();
        return tag.contains(NBT_LAYERS);
    }

    private static int layersFromStack(ItemStack stack, int def) {
        if (stack.isEmpty()) {
            return def;
        }
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = data.copyTag();
        if (!tag.contains(NBT_LAYERS)) {
            return def;
        }
        int value = tag.getInt(NBT_LAYERS);
        return Mth.clamp((int)value, (int)1, (int)8);
    }
}

