/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class UpandDownBlocks
extends Block {
    public static final IntegerProperty COLOUR = IntegerProperty.create((String)"colour", (int)0, (int)8);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    protected static final VoxelShape TOP_AABB = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCTET_NNN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    protected static final VoxelShape OCTET_NNP = Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCTET_NPN = Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape OCTET_NPP = Block.box((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape OCTET_PNN = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape OCTET_PNP = Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCTET_PPN = Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape OCTET_PPP = Block.box((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] TOP_SHAPES = UpandDownBlocks.makeShapes(TOP_AABB, OCTET_NNN, OCTET_PNN, OCTET_NNP, OCTET_PNP);
    protected static final VoxelShape[] BOTTOM_SHAPES = UpandDownBlocks.makeShapes(BOTTOM_AABB, OCTET_NPN, OCTET_PPN, OCTET_NPP, OCTET_PPP);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_56945_ -> UpandDownBlocks.makeStairShape(p_56945_, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape makeStairShape(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = Shapes.or((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }

    public UpandDownBlocks(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)COLOUR, (Comparable)Integer.valueOf(0))).setValue(HALF, (Comparable)Half.BOTTOM)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    protected boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (state.getValue(HALF) == Half.TOP ? TOP_SHAPES : BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(state)]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.getValue(SHAPE)).ordinal() * 4 + ((Direction)state.getValue((Property)FACING)).get2DDataValue();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockPos blockpos = context.getClickedPos();
        FluidState fluidstate = context.getLevel().getFluidState(blockpos);
        BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.getClickLocation().y - (double)blockpos.getY() > 0.5) ? Half.BOTTOM : Half.TOP));
        return (BlockState)blockstate.setValue(SHAPE, (Comparable)UpandDownBlocks.getStairsShape(blockstate, (BlockGetter)context.getLevel(), blockpos));
    }

    @NotNull
    protected BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        return facing.getAxis().isHorizontal() ? (BlockState)state.setValue(SHAPE, (Comparable)UpandDownBlocks.getStairsShape(state, (BlockGetter)level, currentPos)) : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    private static StairsShape getStairsShape(BlockState state, BlockGetter level, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState blockstate = level.getBlockState(pos.relative(direction));
        if (UpandDownBlocks.isStairs(blockstate) && state.getValue(HALF) == blockstate.getValue(HALF) && (direction1 = (Direction)blockstate.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && UpandDownBlocks.canTakeShape(state, level, pos, direction1.getOpposite())) {
            if (direction1 == direction.getCounterClockWise()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = level.getBlockState(pos.relative(direction.getOpposite()));
        if (UpandDownBlocks.isStairs(blockstate1) && state.getValue(HALF) == blockstate1.getValue(HALF) && (direction2 = (Direction)blockstate1.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && UpandDownBlocks.canTakeShape(state, level, pos, direction2)) {
            if (direction2 == direction.getCounterClockWise()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState blockstate = level.getBlockState(pos.relative(face));
        return !UpandDownBlocks.isStairs(blockstate) || blockstate.getValue((Property)FACING) != state.getValue((Property)FACING) || blockstate.getValue(HALF) != state.getValue(HALF);
    }

    public static boolean isStairs(BlockState state) {
        return state.getBlock() instanceof UpandDownBlocks;
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Deprecated
    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.getValue(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                return switch (stairsshape) {
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                return switch (stairsshape) {
                    default -> throw new MatchException(null, null);
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.mirror(state, mirror);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, SHAPE, COLOUR});
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        return false;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (!level.isClientSide && player.isCrouching() && player.isCreative()) {
            int currentColour = (Integer)state.getValue((Property)COLOUR);
            int newColour = (currentColour + 1) % 9;
            level.setBlock(pos, (BlockState)state.setValue((Property)COLOUR, (Comparable)Integer.valueOf(newColour)), 3);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }
}

