/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class StairWall
extends StairBlock {
    private static final VoxelShape NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape SOUTH = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NW = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    private static final VoxelShape NE = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape SW = Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape SE = Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);

    public StairWall(BlockBehaviour.Properties properties) {
        super(Blocks.STONE.defaultBlockState(), properties);
    }

    private static VoxelShape straight(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            default -> SOUTH;
        };
    }

    private static VoxelShape outer(Direction facing, boolean left) {
        return switch (facing) {
            case Direction.NORTH -> {
                if (left) {
                    yield NW;
                }
                yield NE;
            }
            case Direction.SOUTH -> {
                if (left) {
                    yield SE;
                }
                yield SW;
            }
            case Direction.EAST -> {
                if (left) {
                    yield NE;
                }
                yield SE;
            }
            case Direction.WEST -> {
                if (left) {
                    yield SW;
                }
                yield NW;
            }
            default -> SE;
        };
    }

    private static VoxelShape inner(Direction facing, boolean left) {
        return switch (facing) {
            case Direction.NORTH -> Shapes.or((VoxelShape)NORTH, (VoxelShape)(left ? SW : SE));
            case Direction.SOUTH -> Shapes.or((VoxelShape)SOUTH, (VoxelShape)(left ? NE : NW));
            case Direction.EAST -> Shapes.or((VoxelShape)EAST, (VoxelShape)(left ? NW : SW));
            case Direction.WEST -> Shapes.or((VoxelShape)WEST, (VoxelShape)(left ? SE : NE));
            default -> NORTH;
        };
    }

    private static VoxelShape shapeFor(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        StairsShape shape = (StairsShape)state.getValue((Property)SHAPE);
        return switch (shape) {
            default -> throw new MatchException(null, null);
            case StairsShape.STRAIGHT -> StairWall.straight(facing);
            case StairsShape.OUTER_LEFT -> StairWall.outer(facing, true);
            case StairsShape.OUTER_RIGHT -> StairWall.outer(facing, false);
            case StairsShape.INNER_LEFT -> StairWall.inner(facing, true);
            case StairsShape.INNER_RIGHT -> StairWall.inner(facing, false);
        };
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return StairWall.shapeFor(state);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return StairWall.shapeFor(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
    }
}

