/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class SnowlikeLayers
extends Block
implements SimpleWaterloggedBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final IntegerProperty LAYERS = IntegerProperty.create((String)"layers", (int)1, (int)8);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    private static final String NBT_LAYERS = "layers";
    private final Supplier<Block> fullBlock;

    public SnowlikeLayers(BlockBehaviour.Properties properties, Supplier<Block> fullBlock) {
        super(properties.noOcclusion());
        this.fullBlock = Objects.requireNonNull(fullBlock, "fullBlock supplier is null");
        Block fb = this.fullBlock.get();
        if (fb == null) {
            throw new IllegalArgumentException("fullBlock supplier returned null");
        }
        if (fb == this) {
            throw new IllegalArgumentException("fullBlock must not be the same block");
        }
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)Half.BOTTOM));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LAYERS, WATERLOGGED, HALF});
    }

    private static VoxelShape shapeFor(BlockState state) {
        int h = (Integer)state.getValue((Property)LAYERS) * 2;
        if (state.getValue(HALF) == Half.TOP) {
            return Block.box((double)0.0, (double)(16.0 - (double)h), (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)h, (double)16.0);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SnowlikeLayers.shapeFor(state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SnowlikeLayers.shapeFor(state);
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockItem bi;
        Item item = stack.getItem();
        if (!(item instanceof BlockItem) || (bi = (BlockItem)item).getBlock() != this) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player.isSecondaryUseActive()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int l = (Integer)state.getValue((Property)LAYERS);
        if (l >= 8) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            if (l == 7) {
                BlockState full = this.safeFullFrom(state);
                if (full != null) {
                    level.setBlock(pos, full, 3);
                } else {
                    LOGGER.warn("Skipping full-block swap for {} at {} on use: bad mapping; using layer 8 fallback", (Object)this, (Object)pos);
                    level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(8))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
                }
            } else {
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(l + 1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            }
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext ctx) {
        BlockItem bi;
        int l = (Integer)state.getValue((Property)LAYERS);
        Player player = ctx.getPlayer();
        if (player != null && ctx.isSecondaryUseActive()) {
            return false;
        }
        ItemStack stack = ctx.getItemInHand();
        boolean hasLayers = SnowlikeLayers.stackHasLayers(stack);
        Item item = stack.getItem();
        if (item instanceof BlockItem && (bi = (BlockItem)item).getBlock() == this && l < 8 && !hasLayers) {
            return true;
        }
        return l == 1 && super.canBeReplaced(state, ctx);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        double hitY;
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState existing = level.getBlockState(pos);
        ItemStack stack = ctx.getItemInHand();
        boolean hasLayers = SnowlikeLayers.stackHasLayers(stack);
        if (existing.is((Block)this) && !ctx.isSecondaryUseActive() && (Integer)existing.getValue((Property)LAYERS) < 8 && !hasLayers) {
            int l = (Integer)existing.getValue((Property)LAYERS);
            if (l == 7) {
                BlockState full = this.safeFullFrom(existing);
                if (full != null) {
                    return full;
                }
                LOGGER.warn("Skipping full-block swap for {} at {} during placement: bad mapping; using layer 8 fallback", (Object)this, (Object)pos);
                return (BlockState)((BlockState)existing.setValue((Property)LAYERS, (Comparable)Integer.valueOf(8))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            return (BlockState)((BlockState)existing.setValue((Property)LAYERS, (Comparable)Integer.valueOf(l + 1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        Direction face = ctx.getClickedFace();
        Half half = face == Direction.DOWN ? Half.TOP : (face == Direction.UP ? Half.BOTTOM : ((hitY = ctx.getClickLocation().y - (double)pos.getY()) > 0.5 ? Half.TOP : Half.BOTTOM));
        boolean water = level.getFluidState(pos).getType() == Fluids.WATER;
        BlockState base = (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)half)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
        if (hasLayers) {
            int layers = SnowlikeLayers.layersFromStack(stack, 1);
            base = (BlockState)base.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layers));
            if (layers == 8) {
                base = (BlockState)base.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
        } else {
            base = (BlockState)base.setValue((Property)LAYERS, (Comparable)Integer.valueOf(1));
        }
        return base;
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && (Integer)state.getValue((Property)LAYERS) < 8) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, dir, neighborState, level, pos, neighborPos);
    }

    protected FluidState getFluidState(BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && (Integer)state.getValue((Property)LAYERS) < 8) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(state);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag tag = new CompoundTag();
        tag.putInt(NBT_LAYERS, ((Integer)state.getValue((Property)LAYERS)).intValue());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        return stack;
    }

    private static boolean stackHasLayers(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return false;
        }
        CompoundTag tag = data.copyTag();
        return tag != null && tag.contains(NBT_LAYERS);
    }

    private static int layersFromStack(ItemStack stack, int def) {
        if (stack.isEmpty()) {
            return def;
        }
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return def;
        }
        CompoundTag tag = data.copyTag();
        if (tag == null) {
            return def;
        }
        return Mth.clamp((int)tag.getInt(NBT_LAYERS), (int)1, (int)8);
    }

    private BlockState safeFullFrom(BlockState src) {
        Block fb;
        try {
            fb = this.fullBlock.get();
        }
        catch (Exception e) {
            LOGGER.warn("fullBlock supplier threw", (Throwable)e);
            return null;
        }
        if (fb == null || fb == this) {
            return null;
        }
        BlockState full = fb.defaultBlockState();
        if (full.hasProperty((Property)BlockStateProperties.WATERLOGGED) && src.hasProperty((Property)WATERLOGGED)) {
            full = (BlockState)full.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)src.getValue((Property)WATERLOGGED)));
        }
        return full;
    }
}

