/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmallLintels
extends StairBlock {
    private static final VoxelShape NORTH_BOTTOM = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)0.5);
    private static final VoxelShape SOUTH_BOTTOM = Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)0.5, (double)1.0);
    private static final VoxelShape WEST_BOTTOM = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)0.5, (double)1.0);
    private static final VoxelShape EAST_BOTTOM = Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
    private static final VoxelShape NORTH_TOP = Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)0.5);
    private static final VoxelShape SOUTH_TOP = Shapes.box((double)0.0, (double)0.5, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape WEST_TOP = Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)0.5, (double)1.0, (double)1.0);
    private static final VoxelShape EAST_TOP = Shapes.box((double)0.5, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape OUTER_NW_BOTTOM = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)0.5, (double)0.5);
    private static final VoxelShape OUTER_NE_BOTTOM = Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)0.5);
    private static final VoxelShape OUTER_SW_BOTTOM = Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)0.5, (double)0.5, (double)1.0);
    private static final VoxelShape OUTER_SE_BOTTOM = Shapes.box((double)0.5, (double)0.0, (double)0.5, (double)1.0, (double)0.5, (double)1.0);
    private static final VoxelShape OUTER_NW_TOP = Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)0.5, (double)1.0, (double)0.5);
    private static final VoxelShape OUTER_NE_TOP = Shapes.box((double)0.5, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)0.5);
    private static final VoxelShape OUTER_SW_TOP = Shapes.box((double)0.0, (double)0.5, (double)0.5, (double)0.5, (double)1.0, (double)1.0);
    private static final VoxelShape OUTER_SE_TOP = Shapes.box((double)0.5, (double)0.5, (double)0.5, (double)1.0, (double)1.0, (double)1.0);

    public SmallLintels(BlockBehaviour.Properties properties) {
        super(Blocks.STONE.defaultBlockState(), properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        Half half = (Half)state.getValue((Property)HALF);
        StairsShape shape = (StairsShape)state.getValue((Property)SHAPE);
        if (shape == StairsShape.OUTER_LEFT || shape == StairsShape.OUTER_RIGHT) {
            if (half == Half.BOTTOM) {
                return switch (facing) {
                    case Direction.NORTH -> {
                        if (shape == StairsShape.OUTER_LEFT) {
                            yield OUTER_NW_BOTTOM;
                        }
                        yield OUTER_NE_BOTTOM;
                    }
                    case Direction.SOUTH -> {
                        if (shape == StairsShape.OUTER_LEFT) {
                            yield OUTER_SE_BOTTOM;
                        }
                        yield OUTER_SW_BOTTOM;
                    }
                    case Direction.EAST -> {
                        if (shape == StairsShape.OUTER_LEFT) {
                            yield OUTER_NE_BOTTOM;
                        }
                        yield OUTER_SE_BOTTOM;
                    }
                    case Direction.WEST -> {
                        if (shape == StairsShape.OUTER_LEFT) {
                            yield OUTER_SW_BOTTOM;
                        }
                        yield OUTER_NW_BOTTOM;
                    }
                    default -> OUTER_SE_BOTTOM;
                };
            }
            return switch (facing) {
                case Direction.NORTH -> {
                    if (shape == StairsShape.OUTER_LEFT) {
                        yield OUTER_NW_TOP;
                    }
                    yield OUTER_NE_TOP;
                }
                case Direction.SOUTH -> {
                    if (shape == StairsShape.OUTER_LEFT) {
                        yield OUTER_SE_TOP;
                    }
                    yield OUTER_SW_TOP;
                }
                case Direction.EAST -> {
                    if (shape == StairsShape.OUTER_LEFT) {
                        yield OUTER_NE_TOP;
                    }
                    yield OUTER_SE_TOP;
                }
                case Direction.WEST -> {
                    if (shape == StairsShape.OUTER_LEFT) {
                        yield OUTER_SW_TOP;
                    }
                    yield OUTER_NW_TOP;
                }
                default -> OUTER_SE_TOP;
            };
        }
        if (half == Half.TOP) {
            return switch (facing) {
                case Direction.NORTH -> NORTH_TOP;
                case Direction.SOUTH -> SOUTH_TOP;
                case Direction.EAST -> EAST_TOP;
                case Direction.WEST -> WEST_TOP;
                default -> NORTH_TOP;
            };
        }
        return switch (facing) {
            case Direction.NORTH -> NORTH_BOTTOM;
            case Direction.SOUTH -> SOUTH_BOTTOM;
            case Direction.EAST -> EAST_BOTTOM;
            case Direction.WEST -> WEST_BOTTOM;
            default -> NORTH_BOTTOM;
        };
    }
}

