/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class RoseWindow
extends HorizontalDirectionalBlock {
    public static final MapCodec<RoseWindow> CODEC = RoseWindow.simpleCodec(RoseWindow::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    public static final IntegerProperty COLOUR = IntegerProperty.create((String)"colour", (int)0, (int)6);
    private static final VoxelShape S_NORTH = Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    private static final VoxelShape S_SOUTH = Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    private static final VoxelShape S_EAST = Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0);
    private static final VoxelShape S_WEST = Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0);
    private static final VoxelShape S_TOP = Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    private static final VoxelShape S_BOTTOM = Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);

    public RoseWindow(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)Type.TOP))).setValue((Property)COLOUR, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getHorizontalDirection().getOpposite();
        Type type = ctx.getClickedFace() == Direction.UP ? Type.TOP : Type.BOTTOM;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(TYPE, (Comparable)((Object)type))).setValue((Property)COLOUR, (Comparable)Integer.valueOf(0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE, COLOUR});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Type type = (Type)((Object)state.getValue(TYPE));
        if (type == Type.TOP) {
            return S_TOP;
        }
        if (type == Type.BOTTOM) {
            return S_BOTTOM;
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> S_SOUTH;
            case Direction.EAST -> S_EAST;
            case Direction.WEST -> S_WEST;
            default -> S_NORTH;
        };
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide && player.isShiftKeyDown() && player.getAbilities().instabuild) {
            int currentColour = (Integer)state.getValue((Property)COLOUR);
            int newColour = (currentColour + 1) % 7;
            level.setBlock(pos, (BlockState)state.setValue((Property)COLOUR, (Comparable)Integer.valueOf(newColour)), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static enum Type implements StringRepresentable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

