/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LayeredPillar
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty LAYERS = IntegerProperty.create((String)"layers", (int)1, (int)8);
    public static final IntegerProperty COLOUR = IntegerProperty.create((String)"colour", (int)0, (int)6);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final String NBT_LAYERS = "layers";

    public LayeredPillar(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1))).setValue((Property)COLOUR, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LAYERS, COLOUR, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState here = level.getBlockState(pos);
        Player player = ctx.getPlayer();
        ItemStack held = ctx.getItemInHand();
        boolean hasNbtLayers = LayeredPillar.stackHasLayers(held);
        if (here.is((Block)this) && player != null && !ctx.isSecondaryUseActive() && (Integer)here.getValue((Property)LAYERS) < 8 && !hasNbtLayers) {
            return (BlockState)here.setValue((Property)LAYERS, (Comparable)Integer.valueOf((Integer)here.getValue((Property)LAYERS) + 1));
        }
        boolean water = level.getFluidState(pos).getType() == Fluids.WATER;
        int layers = LayeredPillar.layersFromStack(held, 1);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf(layers))).setValue((Property)COLOUR, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext ctx) {
        ItemStack held = ctx.getItemInHand();
        boolean hasNbtLayers = LayeredPillar.stackHasLayers(held);
        if (held.is(this.asItem()) && (Integer)state.getValue((Property)LAYERS) < 8 && !hasNbtLayers) {
            return true;
        }
        return super.canBeReplaced(state, ctx);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        BlockItem blockItem;
        Item item;
        if (player == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player.isSecondaryUseActive() && (item = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() == this) {
            Direction side = hit.getDirection();
            BlockPos target = pos.relative(side);
            BlockHitResult redirected = new BlockHitResult(hit.getLocation(), side, target, false);
            UseOnContext ctx = new UseOnContext(player, hand, redirected);
            InteractionResult result = stack.useOn(ctx);
            return result.consumesAction() ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.is(this.asItem())) {
            int cur = (Integer)state.getValue((Property)LAYERS);
            if (cur >= 8) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(cur + 1)), 3);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shapeFor(state);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shapeFor(state);
    }

    @NotNull
    protected VoxelShape getInteractionShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.shapeFor(state);
    }

    private VoxelShape shapeFor(BlockState state) {
        int size = Mth.clamp((int)((Integer)state.getValue((Property)LAYERS) * 2), (int)2, (int)16);
        int half = size / 2;
        int x0 = 8 - half;
        int x1 = 8 + half;
        int z0 = 8 - half;
        int z1 = 8 + half;
        return Block.box((double)x0, (double)0.0, (double)z0, (double)x1, (double)16.0, (double)z1);
    }

    @NotNull
    public VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return (Integer)state.getValue((Property)LAYERS) >= 8 ? Shapes.block() : Shapes.empty();
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction dir, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, dir, neighborState, level, pos, neighborPos);
    }

    private static boolean stackHasLayers(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return false;
        }
        CompoundTag tag = data.copyTag();
        return tag != null && tag.contains(NBT_LAYERS);
    }

    private static int layersFromStack(ItemStack stack, int def) {
        if (stack.isEmpty()) {
            return def;
        }
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return def;
        }
        CompoundTag tag = data.copyTag();
        if (tag == null) {
            return def;
        }
        return Mth.clamp((int)tag.getInt(NBT_LAYERS), (int)1, (int)8);
    }
}

