/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EighthBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Corner> CORNER = EnumProperty.create((String)"corner", Corner.class);
    private static final int S = 8;
    private static final VoxelShape NE_BOTTOM = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    private static final VoxelShape SE_BOTTOM = Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SW_BOTTOM = Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    private static final VoxelShape NW_BOTTOM = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    private static final VoxelShape NE_TOP = Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape SE_TOP = Block.box((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SW_TOP = Block.box((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape NW_TOP = Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);

    public EighthBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)Half.BOTTOM)).setValue(CORNER, (Comparable)((Object)Corner.NE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, CORNER, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction face = ctx.getClickedFace();
        BlockPos pos = ctx.getClickedPos();
        double localY = ctx.getClickLocation().y - (double)pos.getY();
        Half half = face == Direction.DOWN ? Half.TOP : (face == Direction.UP ? Half.BOTTOM : (localY > 0.5 ? Half.TOP : Half.BOTTOM));
        double localX = ctx.getClickLocation().x - (double)pos.getX();
        double localZ = ctx.getClickLocation().z - (double)pos.getZ();
        Corner corner = localX >= 0.5 ? (localZ >= 0.5 ? Corner.SE : Corner.NE) : (localZ >= 0.5 ? Corner.SW : Corner.NW);
        boolean water = ctx.getLevel().getFluidState(pos).getType() == Fluids.WATER;
        Direction facing = ctx.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(HALF, (Comparable)half)).setValue(CORNER, (Comparable)((Object)corner))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    private VoxelShape shapeFor(BlockState state) {
        boolean top = state.getValue(HALF) == Half.TOP;
        return switch (((Corner)((Object)state.getValue(CORNER))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                if (top) {
                    yield NE_TOP;
                }
                yield NE_BOTTOM;
            }
            case 2 -> {
                if (top) {
                    yield SE_TOP;
                }
                yield SE_BOTTOM;
            }
            case 3 -> {
                if (top) {
                    yield SW_TOP;
                }
                yield SW_BOTTOM;
            }
            case 0 -> top ? NW_TOP : NW_BOTTOM;
        };
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeFor(state);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeFor(state);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)))).setValue(CORNER, (Comparable)((Object)((Corner)((Object)state.getValue(CORNER))).rotate(rotation)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING))).setValue(CORNER, (Comparable)((Object)((Corner)((Object)state.getValue(CORNER))).mirror(mirror)));
    }

    public static enum Corner implements StringRepresentable
    {
        NW("nw"),
        NE("ne"),
        SE("se"),
        SW("sw");

        private final String name;

        private Corner(String n2) {
            this.name = n2;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public Corner rotate(Rotation rot) {
            return switch (rot) {
                default -> throw new MatchException(null, null);
                case Rotation.NONE -> this;
                case Rotation.CLOCKWISE_90 -> {
                    switch (this.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield NE;
                        }
                        case 1: {
                            yield SE;
                        }
                        case 2: {
                            yield SW;
                        }
                        case 3: 
                    }
                    yield NW;
                }
                case Rotation.CLOCKWISE_180 -> {
                    switch (this.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield SE;
                        }
                        case 1: {
                            yield SW;
                        }
                        case 2: {
                            yield NW;
                        }
                        case 3: 
                    }
                    yield NE;
                }
                case Rotation.COUNTERCLOCKWISE_90 -> {
                    switch (this.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield SW;
                        }
                        case 1: {
                            yield NW;
                        }
                        case 2: {
                            yield NE;
                        }
                        case 3: 
                    }
                    yield SE;
                }
            };
        }

        public Corner mirror(Mirror mirror) {
            return switch (mirror) {
                default -> throw new MatchException(null, null);
                case Mirror.NONE -> this;
                case Mirror.LEFT_RIGHT -> {
                    switch (this.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield SW;
                        }
                        case 1: {
                            yield SE;
                        }
                        case 2: {
                            yield NE;
                        }
                        case 3: 
                    }
                    yield NW;
                }
                case Mirror.FRONT_BACK -> {
                    switch (this.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield NE;
                        }
                        case 1: {
                            yield NW;
                        }
                        case 2: {
                            yield SW;
                        }
                        case 3: 
                    }
                    yield SE;
                }
            };
        }
    }
}

