/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets.packets.magnet;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.simplemagnets.MagnetItem;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class PacketToggleMagnet
implements BasePacket {
    public void write(FriendlyByteBuf buffer) {
    }

    public void read(FriendlyByteBuf buffer) {
    }

    public void handle(PacketContext context) {
        ItemStack stack;
        Player player = context.getSendingPlayer();
        if (player != null && (stack = PacketToggleMagnet.findStack(player)) != null && !stack.isEmpty()) {
            MagnetItem.toggleMagnet(player, stack);
        }
    }

    private static ItemStack findStack(Player player) {
        ItemStack stack = PacketToggleMagnet.findCuriosStack(player);
        if (stack != null && !stack.isEmpty() && stack.getItem() instanceof MagnetItem) {
            return stack;
        }
        for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
            stack = player.getInventory().getItem(slot);
            if (stack.isEmpty() || !(stack.getItem() instanceof MagnetItem)) continue;
            return stack;
        }
        return null;
    }

    private static ItemStack findCuriosStack(Player player) {
        ICuriosItemHandler handler;
        if (CommonUtils.isModLoaded((String)"curios") && (handler = (ICuriosItemHandler)player.getCapability(CuriosCapability.INVENTORY)) != null) {
            for (IDynamicStackHandler stackHandler : handler.getCurios().values().stream().map(ICurioStacksHandler::getStacks).collect(Collectors.toSet())) {
                for (int slot = 0; slot < stackHandler.getSlots(); ++slot) {
                    ItemStack stack = stackHandler.getStackInSlot(slot);
                    if (!(stack.getItem() instanceof MagnetItem)) continue;
                    return stack;
                }
            }
        }
        return null;
    }
}

