/*
 * Decompiled with CFR 0.152.
 */
package com.jerrylu086.netherite_horse_armor;

import com.google.common.collect.ImmutableList;
import com.jerrylu086.netherite_horse_armor.Configuration;
import com.jerrylu086.netherite_horse_armor.data.EasyCraftingCondition;
import com.jerrylu086.netherite_horse_armor.mixin.accessor.LootPoolAccessor;
import com.jerrylu086.netherite_horse_armor.mixin.accessor.LootTableAccessor;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="netherite_horse_armor")
public class NetheriteHorseArmor {
    public static final String MOD_ID = "netherite_horse_armor";
    public static final Logger LOGGER = LogManager.getLogger((String)"netherite_horse_armor");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"netherite_horse_armor");
    public static final DeferredRegister<MapCodec<? extends ICondition>> CODECS = DeferredRegister.create((Registry)NeoForgeRegistries.CONDITION_SERIALIZERS, (String)"netherite_horse_armor");
    public static final DeferredItem<Item> NETHERITE_HORSE_ARMOR = ITEMS.register("netherite_horse_armor", () -> new AnimalArmorItem(ArmorMaterials.NETHERITE, AnimalArmorItem.BodyType.EQUESTRIAN, false, new Item.Properties().stacksTo(1).fireResistant()){

        public ResourceLocation getTexture() {
            return ResourceLocation.fromNamespaceAndPath((String)NetheriteHorseArmor.MOD_ID, (String)super.getTexture().getPath());
        }
    });
    public static final Supplier<MapCodec<? extends ICondition>> EASY_CRAFTING = CODECS.register("easy_crafting", () -> EasyCraftingCondition.CODEC);

    public NetheriteHorseArmor(IEventBus modEventBus) {
        ITEMS.register(modEventBus);
        CODECS.register(modEventBus);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.COMMON);
        modEventBus.addListener(this::addToTab);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void addToTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            event.insertAfter(new ItemStack((ItemLike)Items.DIAMOND_HORSE_ARMOR), new ItemStack((ItemLike)NETHERITE_HORSE_ARMOR.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (!event.getName().equals((Object)BuiltInLootTables.BASTION_TREASURE.location()) || (Integer)Configuration.WEIGHT.get() <= 0) {
            return;
        }
        LootPoolEntryContainer entry = LootItem.lootTableItem((ItemLike)((ItemLike)NETHERITE_HORSE_ARMOR.get())).setWeight(((Integer)Configuration.WEIGHT.get()).intValue()).setQuality(1).build();
        List<LootPool> pools = ((LootTableAccessor)event.getTable()).getPools();
        if (pools != null && !pools.isEmpty()) {
            LootPool firstPool = pools.get(0);
            List<LootPoolEntryContainer> entries = ((LootPoolAccessor)firstPool).getEntries();
            ImmutableList newEntries = ImmutableList.builder().addAll(entries).add((Object)entry).build();
            ((LootPoolAccessor)firstPool).setEntries((List<LootPoolEntryContainer>)newEntries);
            LOGGER.info("Successfully modified loot table: '{}'", (Object)BuiltInLootTables.BASTION_TREASURE.location());
        }
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

