/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.util;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;

public class BlendUtil {
    public static double blendBiomeEdge(Holder<Biome> currentBiome, Function<BlockPos, Holder<Biome>> biomeGetter, BlockPos origin, int blendRadius, int blendStep) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int size = Math.floorDiv(blendRadius, blendStep);
        for (BlockPos.MutableBlockPos blockPos : BlockPos.spiralAround((BlockPos)BlockPos.ZERO, (int)size, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            double distToLowCornerSqr;
            int x = origin.getX() + blockPos.getX() * blendStep;
            int z = origin.getZ() + blockPos.getZ() * blendStep;
            mutableBlockPos.set(x, origin.getY(), z);
            Holder<Biome> nearbyBiome = biomeGetter.apply((BlockPos)mutableBlockPos);
            if (nearbyBiome == currentBiome || !((distToLowCornerSqr = mutableBlockPos.distToLowCornerSqr((double)origin.getX(), (double)origin.getY(), (double)origin.getZ())) < (double)Mth.square((int)blendRadius))) continue;
            return distToLowCornerSqr / (double)Mth.square((int)blendRadius);
        }
        return 1.0;
    }
}

