/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.customterrain;

import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.util.GeneratorHeightGetter;
import net.potionstudios.biomeswevegone.util.MathUtil;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import net.potionstudios.biomeswevegone.world.level.levelgen.util.BlendUtil;
import org.joml.Vector2d;
import org.joml.Vector4d;

public class BasaltBarreraExtension {
    public static void runBasaltBarreraExtension(Function<BlockPos, Holder<Biome>> biomeGetter, ChunkAccess chunk, WorldGenRegion region, ChunkGenerator generator) {
        ChunkPos pos = chunk.getPos();
        ImprovedNoise hexRadiusNoise = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(region.getSeed()));
        ImprovedNoise hexHeightNoise = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(region.getSeed() + 2394504L));
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = pos.getBlockX(x);
                int worldZ = pos.getBlockZ(z);
                int landHeight = chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, worldX, worldZ) / 10 * 10;
                if (chunk.getMinBuildHeight() >= landHeight) continue;
                mutable.set(worldX, landHeight, worldZ);
                Holder<Biome> currentBiome = biomeGetter.apply((BlockPos)mutable);
                if (!currentBiome.is(BWGBiomes.BASALT_BARRERA)) continue;
                double hexRadiusNoiseFreq = 0.01;
                double hexDelta = (hexRadiusNoise.noise((double)mutable.getX() * hexRadiusNoiseFreq, 0.0, (double)mutable.getZ() * hexRadiusNoiseFreq) + 1.0) * 0.5;
                int hexRadius = (int)BlendingFunction.EaseInOutCirc.INSTANCE.apply(hexDelta, 4.0, 10.0);
                Vector4d vector4d = MathUtil.calcHexInfo(new Vector2d((double)mutable.getX(), (double)mutable.getZ()), hexRadius);
                Vector2d hexCenter = new Vector2d((double)mutable.getX() - vector4d.x, (double)mutable.getZ() - vector4d.y);
                mutable.set(hexCenter.x, (double)mutable.getY(), hexCenter.y);
                Holder<Biome> hexCenterBiome = biomeGetter.apply((BlockPos)mutable);
                if (!hexCenterBiome.is(BWGBiomes.BASALT_BARRERA)) continue;
                double biomeBlend = BlendUtil.blendBiomeEdge(currentBiome, biomeGetter, (BlockPos)mutable, hexRadius * 2, 1);
                ChunkAccess hexCenterChunk = region.getChunk((BlockPos)mutable);
                if (!(hexCenterChunk instanceof GeneratorHeightGetter)) continue;
                GeneratorHeightGetter generatorHeightGetter = (GeneratorHeightGetter)hexCenterChunk;
                Random random = new Random(mutable.asLong() + region.getSeed());
                BlockState state = random.nextBoolean() ? Blocks.BASALT.defaultBlockState() : Blocks.SMOOTH_BASALT.defaultBlockState();
                int hexHeightOceanFloorHeight = generatorHeightGetter.getHeight(generator, Heightmap.Types.OCEAN_FLOOR_WG, mutable.getX(), mutable.getZ(), region.getLevel().getChunkSource().randomState(), true);
                double noiseFreq = 0.1;
                mutable.set(worldX, hexHeightOceanFloorHeight, worldZ);
                double heightDelta = (hexHeightNoise.noise(hexCenter.x * noiseFreq, 0.0, hexCenter.y * noiseFreq) + 1.0) * 0.5;
                double addedHeight = BlendingFunction.EaseInOutCirc.INSTANCE.apply(heightDelta, 1.0, 4.0);
                double topY = (double)hexHeightOceanFloorHeight + addedHeight;
                double blendedY = Mth.clampedLerp((double)landHeight, (double)topY, (double)biomeBlend);
                int worldY = landHeight - 5;
                while ((double)worldY <= blendedY) {
                    mutable.set(worldX, worldY, worldZ);
                    chunk.setBlockState((BlockPos)mutable, state, false);
                    ++worldY;
                }
            }
        }
    }
}

