/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritech.compat.jade;

import com.blocklogic.agritech.block.entity.AgritechPlanterBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum PlanterProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (!data.contains("hasCrop") || !data.getBoolean("hasCrop")) {
            return;
        }
        String cropName = data.getString("cropName");
        int currentStage = data.getInt("currentStage");
        int maxStage = data.getInt("maxStage");
        float progressPercent = data.getFloat("progressPercent");
        String soilName = data.getString("soilName");
        float growthModifier = data.getFloat("growthModifier");
        if (currentStage >= maxStage) {
            tooltip.add((Component)Component.translatable((String)"jade.agritech.crop_ready", (Object[])new Object[]{cropName}));
        } else {
            tooltip.add((Component)Component.translatable((String)"jade.agritech.crop_progress", (Object[])new Object[]{cropName, currentStage, maxStage, Math.round(progressPercent)}).withStyle(ChatFormatting.DARK_GREEN));
        }
        tooltip.add((Component)Component.translatable((String)"jade.agritech.soil_info", (Object[])new Object[]{soilName, String.format("%.2fx", Float.valueOf(growthModifier))}));
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof AgritechPlanterBlockEntity)) {
            return;
        }
        AgritechPlanterBlockEntity planter = (AgritechPlanterBlockEntity)blockEntity;
        ItemStack seedStack = planter.inventory.getStackInSlot(0);
        ItemStack soilStack = planter.inventory.getStackInSlot(1);
        if (!seedStack.isEmpty() && !soilStack.isEmpty()) {
            data.putBoolean("hasCrop", true);
            data.putString("cropName", seedStack.getDisplayName().getString());
            data.putInt("currentStage", planter.getGrowthStage());
            data.putInt("maxStage", planter.maxGrowthStage);
            data.putFloat("progressPercent", planter.getGrowthProgress() * 100.0f);
            data.putString("soilName", soilStack.getDisplayName().getString());
            data.putFloat("growthModifier", planter.getGrowthModifier(soilStack));
        } else {
            data.putBoolean("hasCrop", false);
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"agritech", (String)"planter_info");
    }
}

